/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.builder.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;

public class GLayoutOptions
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = -6422190064984638890L;
    public static final String KEY_H_ALIGN = "hAlign";
    public static final String KEY_V_ALIGN = "vAlign";
    public static final String KEY_RESIZE_CONTAINER = "resizeContainer";
    public static final String KEY_PADDING_LEFT = "paddingLeft";
    public static final String KEY_PADDING_RIGHT = "paddingRight";
    public static final String KEY_PADDING_TOP = "paddingTop";
    public static final String KEY_PADDING_BOTTOM = "paddingBottom";
    public static final String KEY_PADDING_FACTOR = "paddingFactor";
    public static final String KEY_H_GAP = "hGap";
    public static final String KEY_V_GAP = "vGap";
    public static final String KEY_MIN_WIDTH = "minWidth";
    public static final String KEY_MIN_HEIGHT = "minHeight";
    public static final String KEY_PREF_WIDTH = "prefWidth";
    public static final String KEY_PREF_HEIGHT = "prefHeight";
    public static final String KEY_H_GRAB = "hGrab";
    public static final String KEY_V_GRAB = "vGrab";

    public GLayoutOptions() {
    }

    public GLayoutOptions(Map<String, Object> values) {
        this.putAll(values);
    }

    public GLayoutOptions(EMap<String, Object> values) {
        this.putAll(values.map());
    }

    public GLayoutOptions paddingLeft(Number paddingLeft) {
        this.putOrRemove(KEY_PADDING_LEFT, paddingLeft);
        return this;
    }

    public Double getPaddingLeft() {
        return this.getDouble(KEY_PADDING_LEFT);
    }

    public GLayoutOptions paddingRight(Number paddingRight) {
        this.putOrRemove(KEY_PADDING_RIGHT, paddingRight);
        return this;
    }

    public Double getPaddingRight() {
        return this.getDouble(KEY_PADDING_RIGHT);
    }

    public GLayoutOptions paddingTop(Number paddingTop) {
        this.putOrRemove(KEY_PADDING_TOP, paddingTop);
        return this;
    }

    public Double getPaddingTop() {
        return this.getDouble(KEY_PADDING_TOP);
    }

    public GLayoutOptions paddingBottom(Double paddingBottom) {
        this.putOrRemove(KEY_PADDING_BOTTOM, paddingBottom);
        return this;
    }

    public Double getPaddingBottom() {
        return this.getDouble(KEY_PADDING_BOTTOM);
    }

    public GLayoutOptions paddingFactor(Number paddingFactor) {
        this.putOrRemove(KEY_PADDING_FACTOR, paddingFactor);
        return this;
    }

    public Double getPaddingFactor() {
        return this.getDouble(KEY_PADDING_FACTOR);
    }

    public GLayoutOptions resizeContainer(boolean resizeContainer) {
        this.putOrRemove(KEY_RESIZE_CONTAINER, resizeContainer);
        return this;
    }

    public Boolean getResizeContainer() {
        return this.getBoolean(KEY_RESIZE_CONTAINER);
    }

    public GLayoutOptions vGap(Number vGap) {
        this.putOrRemove(KEY_V_GAP, vGap);
        return this;
    }

    public String getVGap() {
        return this.getString(KEY_V_GAP);
    }

    public GLayoutOptions hGap(Number hGap) {
        this.putOrRemove(KEY_H_GAP, hGap);
        return this;
    }

    public String getHGap() {
        return this.getString(KEY_H_GAP);
    }

    public GLayoutOptions vAlign(String vAlign) {
        this.putOrRemove(KEY_V_ALIGN, vAlign);
        return this;
    }

    public String getVAlign() {
        return this.getString(KEY_V_ALIGN);
    }

    public GLayoutOptions hAlign(String hAlign) {
        this.putOrRemove(KEY_H_ALIGN, hAlign);
        return this;
    }

    public String getHAlign() {
        return this.getString(KEY_H_ALIGN);
    }

    public GLayoutOptions minWidth(Number minWidth) {
        this.putOrRemove(KEY_MIN_WIDTH, minWidth);
        return this;
    }

    public Double getMinWidth() {
        return this.getDouble(KEY_MIN_WIDTH);
    }

    public GLayoutOptions minHeight(Number minHeight) {
        this.putOrRemove(KEY_MIN_HEIGHT, minHeight);
        return this;
    }

    public Double getMinHeight() {
        return this.getDouble(KEY_MIN_HEIGHT);
    }

    public GLayoutOptions prefWidth(Number minWidth) {
        this.putOrRemove(KEY_PREF_WIDTH, minWidth);
        return this;
    }

    public Double getPrefWidth() {
        return this.getDouble(KEY_PREF_WIDTH);
    }

    public GLayoutOptions prefHeight(Number minHeight) {
        this.putOrRemove(KEY_PREF_HEIGHT, minHeight);
        return this;
    }

    public Double getPrefHeight() {
        return this.getDouble(KEY_PREF_HEIGHT);
    }

    public GLayoutOptions vGrab(Number vGap) {
        this.putOrRemove(KEY_V_GRAB, vGap);
        return this;
    }

    public String getVGrab() {
        return this.getString(KEY_V_GRAB);
    }

    public GLayoutOptions hGrab(Number hGap) {
        this.putOrRemove(KEY_H_GRAB, hGap);
        return this;
    }

    public String getHGrab() {
        return this.getString(KEY_H_GRAB);
    }

    protected void putOrRemove(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }

    protected Double getDouble(String key) {
        Object value = this.get(key);
        return value instanceof Double ? (Double)value : null;
    }

    protected Boolean getBoolean(String key) {
        Object value = this.get(key);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    protected String getString(String key) {
        Object value = this.get(key);
        return value != null ? value.toString() : null;
    }
}

