/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.Map;
import org.eclipse.glsp.graph.gson.EnumTypeAdapter;
import org.eclipse.glsp.graph.gson.GraphGsonConfigurator;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.diagram.ServerConfigurationContribution;
import org.eclipse.glsp.server.gson.ActionTypeAdapter;
import org.eclipse.glsp.server.gson.ServerGsonConfigurator;
import org.eclipse.glsp.server.protocol.InitializeClientSessionParameters;
import org.eclipse.glsp.server.session.ClientSession;
import org.eclipse.glsp.server.session.ClientSessionManager;

public class DefaultServerGsonConfigurator
implements ServerGsonConfigurator {
    protected ActionRegistry actionRegistry;
    protected GraphGsonConfigurator graphGsonConfigurator;

    @Inject
    public DefaultServerGsonConfigurator(Injector serverInjector, @Named(value="Diagram_Modules") Map<String, Module> diagramModules, ActionRegistry actionRegistry, ClientSessionManager sessionManager) {
        this.actionRegistry = actionRegistry;
        this.graphGsonConfigurator = this.createGraphGsonConfigurator();
        this.configure(diagramModules, sessionManager);
    }

    protected void configure(Map<String, Module> diagramModules, ClientSessionManager sessionManager) {
        diagramModules.keySet().forEach(diagramType -> {
            String sessionId = "TempServerConfigurationSession_" + diagramType;
            InitializeClientSessionParameters params = new InitializeClientSessionParameters(sessionId, (String)diagramType, Collections.emptyList());
            ClientSession session = sessionManager.getOrCreateClientSession(params);
            ServerConfigurationContribution contribution = (ServerConfigurationContribution)session.getInjector().getInstance(ServerConfigurationContribution.class);
            contribution.configure(this.actionRegistry);
            contribution.configure(this.graphGsonConfigurator);
            sessionManager.disposeClientSession(sessionId);
        });
    }

    protected TypeAdapterFactory getActionTypeAdapterFactory() {
        return new ActionTypeAdapter.Factory(this.actionRegistry.getAllAsMap());
    }

    protected GraphGsonConfigurator createGraphGsonConfigurator() {
        return new GraphGsonConfigurator();
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapterFactory(this.getActionTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory());
        return this.graphGsonConfigurator.configureGsonBuilder(gsonBuilder);
    }
}

