/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;

public class SynchronizeRepositoryJob
extends Job {
    public static final String SYNCHRONIZE_REPOSITORY_JOB_NAME = "Synchronizing Repository";
    private SynchronizerRepositoryClient client;

    public SynchronizeRepositoryJob(SynchronizerRepositoryClient client) {
        super(SYNCHRONIZE_REPOSITORY_JOB_NAME);
        this.client = client;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        if (this.client.getRepositoryObjectHandler() == null) {
            return Status.CANCEL_STATUS;
        }
        final RepositoryAdapter repositoryAdapter = this.client.getRepositoryObjectHandler().getRepositoryAdapter();
        repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                repositoryAdapter.openSaveContext();
                SynchronizeRepositoryJob.this.client.setTraceabilityIndex((TraceabilityIndex)repositoryAdapter.reload((EObject)SynchronizeRepositoryJob.this.client.getTraceabilityIndex()));
                IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Synchronizer] Start synchronization");
                SynchronizeRepositoryJob.this.synchronize(monitor, repositoryAdapter);
                repositoryAdapter.closeContext();
            }
        });
        return Status.OK_STATUS;
    }

    private void synchronize(IProgressMonitor monitor, RepositoryAdapter repositoryAdapter) {
        Collection<Object> statusList = new ArrayList();
        try {
            statusList = this.client.getSynchronizer().synchronize(repositoryAdapter, this.client.getTraceabilityIndex(), BasicMonitor.toMonitor((IProgressMonitor)monitor));
        }
        catch (InterruptedException interruptedException) {
            IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Synchronizer] Canceled.");
        }
        if (!monitor.isCanceled()) {
            this.client.addAllStatusToTargetElement(statusList);
            try {
                repositoryAdapter.save();
            }
            catch (ReadOnlyException readOnlyException) {
            }
            catch (SaveException saveException) {
                try {
                    repositoryAdapter.undo();
                }
                catch (ReadOnlyException readOnlyException) {}
            }
            IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Synchronizer] Synchronization ended, detected " + statusList.size() + " synchronization issues");
        }
    }
}

