/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationErrorType;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidValueException;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ContributionInstructionGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.InstanciationInstructionGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.NativeValueForStructuralFeatureGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ReferenceValueForStructuralFeatureGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking.ModelingUnitLinkResolver;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.IntentCompilerInformationHolder;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.LabelDeclaration;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AnnotationDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.IntentReferenceinModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.util.ModelingUnitSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitGenerator
extends ModelingUnitSwitch<List<Object>> {
    private ModelingUnitLinkResolver linkResolver;
    private List<String> currentImportedPackages;
    private List<ResourceDeclaration> resourceDeclarations;
    private boolean generateOnlyEPackages;
    private IntentCompilerInformationHolder informationHolder;
    private Monitor progressMonitor;

    public ModelingUnitGenerator(ModelingUnitLinkResolver linkResolver, IntentCompilerInformationHolder informationHolder, Monitor progressMonitor) {
        this.linkResolver = linkResolver;
        this.resourceDeclarations = new ArrayList<ResourceDeclaration>();
        this.generateOnlyEPackages = false;
        this.informationHolder = informationHolder;
        this.progressMonitor = progressMonitor;
    }

    public void generate(ModelingUnit mu) {
        this.doSwitch((EObject)mu);
    }

    public List<ResourceDeclaration> getResourceDeclarations() {
        return this.resourceDeclarations;
    }

    public static void clearCompilationStatus(IntentGenericElement element) {
        Iterator iterator = element.getCompilationStatus().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public List<Object> caseModelingUnit(ModelingUnit modelingUnit) {
        ArrayList<Object> createdObject = new ArrayList<Object>();
        this.currentImportedPackages = this.getImportedPackages(modelingUnit);
        for (UnitInstruction instruction : modelingUnit.getInstructions()) {
            if (!this.isInstructionToConsider(instruction) || this.progressMonitor.isCanceled()) continue;
            this.doSwitch((EObject)instruction);
        }
        return createdObject;
    }

    private boolean isInstructionToConsider(UnitInstruction instruction) {
        boolean isModelingUnitToConsider = this.isGenerateOnlyEPackages() && this.isDescribingEPackages(instruction);
        isModelingUnitToConsider = isModelingUnitToConsider || !this.isGenerateOnlyEPackages() && !this.isDescribingEPackages(instruction);
        return isModelingUnitToConsider;
    }

    private boolean isDescribingEPackages(UnitInstruction instruction) {
        boolean isDescribingEPackages = false;
        if (!this.progressMonitor.isCanceled()) {
            if (instruction instanceof InstanciationInstruction) {
                boolean bl = isDescribingEPackages = isDescribingEPackages || InstanciationInstructionGenerator.isEPackageInstanciation((InstanciationInstruction)instruction);
            }
            if (instruction instanceof ContributionInstruction) {
                ContributionInstruction contributionInstruction = (ContributionInstruction)instruction;
                ContributionInstructionGenerator.generate(contributionInstruction, this, this.linkResolver);
            }
        }
        return isDescribingEPackages;
    }

    public List<Object> caseInstanciationInstruction(InstanciationInstruction instanciationInstruction) {
        ArrayList<Object> createdObject = new ArrayList<Object>();
        createdObject.add(InstanciationInstructionGenerator.generate(instanciationInstruction, this.currentImportedPackages, this.linkResolver, this));
        return createdObject;
    }

    public List<Object> caseContributionInstruction(ContributionInstruction contributionInstruction) {
        ArrayList<Object> createdObject = new ArrayList<Object>();
        return createdObject;
    }

    public List<Object> caseResourceDeclaration(ResourceDeclaration resourceDeclaration) {
        ModelingUnitGenerator.clearCompilationStatus((IntentGenericElement)resourceDeclaration);
        this.resourceDeclarations.add(resourceDeclaration);
        return new ArrayList<Object>();
    }

    public List<Object> caseNativeValueForStructuralFeature(NativeValueForStructuralFeature value) {
        ArrayList<Object> createdObject = new ArrayList<Object>();
        try {
            createdObject.add(NativeValueForStructuralFeatureGenerator.generate(value, this.linkResolver, this));
        }
        catch (InvalidValueException e) {
            this.getInformationHolder().registerCompilationExceptionAsCompilationStatus(new CompilationException(e.getInvalidInstruction(), CompilationErrorType.INVALID_VALUE_ERROR, "The value " + e.getMessage()));
        }
        return createdObject;
    }

    public List<Object> caseReferenceValueForStructuralFeature(ReferenceValueForStructuralFeature referenceValue) {
        ArrayList<Object> createdObject = new ArrayList<Object>();
        createdObject.add(ReferenceValueForStructuralFeatureGenerator.generate(referenceValue, this.linkResolver, this));
        return createdObject;
    }

    public List<Object> caseNewObjectValueForStructuralFeature(NewObjectValueForStructuralFeature value) {
        ArrayList<Object> createdObjects = new ArrayList<Object>();
        createdObjects.addAll((Collection)this.doSwitch((EObject)value.getValue()));
        return createdObjects;
    }

    @Deprecated
    public List<String> getImportedPackages(ModelingUnit mu) {
        return this.informationHolder.getCurrentImportedPackages();
    }

    public List<Object> caseLabelDeclaration(LabelDeclaration object) {
        return new ArrayList<Object>();
    }

    public List<Object> caseAnnotationDeclaration(AnnotationDeclaration object) {
        return new ArrayList<Object>();
    }

    public List<Object> caseIntentReferenceinModelingUnit(IntentReferenceinModelingUnit object) {
        return new ArrayList<Object>();
    }

    public void setGenerateOnlyEPackages(boolean generateOnlyEPackages) {
        this.generateOnlyEPackages = generateOnlyEPackages;
    }

    public boolean isGenerateOnlyEPackages() {
        return this.generateOnlyEPackages;
    }

    public IntentCompilerInformationHolder getInformationHolder() {
        return this.informationHolder;
    }

    public void clearResourceDeclarations() {
        this.resourceDeclarations.clear();
    }
}

