/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer.descriptionunit;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnitInstruction;
import org.eclipse.mylyn.docs.intent.markup.markup.Paragraph;
import org.eclipse.mylyn.docs.intent.markup.serializer.WikiTextSerializer;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;
import org.eclipse.mylyn.docs.intent.serializer.descriptionunit.internal.DescriptionUnitElementsDispatcher;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentDocumentSerializerSwitch;

public class DescriptionUnitSerializer {
    private WikiTextSerializer markupSerializer = new WikiTextSerializer();
    private DescriptionUnitElementsDispatcher descriptionUnitDispatcher = new DescriptionUnitElementsDispatcher(this);
    private IntentDocumentSerializerSwitch genericDispatcher;
    private IntentPositionManager positionManager;
    private int currentOffset;

    public DescriptionUnitSerializer(IntentDocumentSerializerSwitch genericSerializer) {
        this.genericDispatcher = genericSerializer;
        this.positionManager = new IntentPositionManager();
    }

    public void clear() {
        this.positionManager.clear();
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public void setCurrentOffset(int offset) {
        this.currentOffset = offset;
    }

    public String serialize(DescriptionUnit elementToSerialize) {
        return this.serialize(elementToSerialize, "");
    }

    public String serialize(DescriptionUnit elementToSerialize, String tabulationPrefix) {
        return this.serialize(elementToSerialize, "", 0);
    }

    public String serialize(DescriptionUnit elementToSerialize, String tabulationPrefix, int initialOffset) {
        this.descriptionUnitDispatcher.setTabulationPrefix(tabulationPrefix);
        this.genericDispatcher.setTabulationPrefix(tabulationPrefix);
        StringBuilder renderedDescriptionUnit = new StringBuilder();
        StringBuilder prefixForDescriptionUnit = new StringBuilder();
        prefixForDescriptionUnit.append("\n");
        if (!elementToSerialize.getInstructions().isEmpty() && elementToSerialize.getInstructions().get(0) instanceof DescriptionUnitInstruction) {
            prefixForDescriptionUnit.append(tabulationPrefix);
        }
        int declarationOffset = initialOffset + prefixForDescriptionUnit.length();
        for (UnitInstruction instruction : elementToSerialize.getInstructions()) {
            this.setCurrentOffset(renderedDescriptionUnit.length() + declarationOffset);
            if (instruction instanceof DescriptionUnitInstruction) {
                renderedDescriptionUnit.append((String)this.descriptionUnitDispatcher.doSwitch((EObject)instruction));
                continue;
            }
            String serializedInstruction = (String)this.genericDispatcher.doSwitch((EObject)instruction);
            this.getPositionManager().setPositionForInstruction((EObject)instruction, this.getCurrentOffset(), serializedInstruction.length());
            renderedDescriptionUnit.append(serializedInstruction);
            if (!instruction.isLineBreak() || elementToSerialize.getInstructions().indexOf((Object)instruction) == elementToSerialize.getInstructions().size() - 1) continue;
            renderedDescriptionUnit.append(tabulationPrefix);
        }
        this.positionManager.setPositionForInstruction((EObject)elementToSerialize, declarationOffset, renderedDescriptionUnit.length());
        return String.valueOf(prefixForDescriptionUnit.toString()) + renderedDescriptionUnit.toString();
    }

    public String serializeSectionTitle(EObject sectionTitle, int currentSerializerOffset) {
        String serializedForm = this.markupSerializer.serialize(sectionTitle);
        this.positionManager.setPositionForInstruction(sectionTitle, currentSerializerOffset, serializedForm.length());
        return serializedForm;
    }

    public WikiTextSerializer getMarkupSerializer() {
        return this.markupSerializer;
    }

    public IntentPositionManager getPositionManager() {
        return this.positionManager;
    }

    public String serialize(Paragraph elementToSerialize) {
        return this.serializeSectionTitle((EObject)elementToSerialize, 0);
    }
}

