/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.markup.markup.Entity;

public final class EntitySerializer {
    private static final String COPYRIGHT_CODE = "#169";
    private static final String COPYRIGHT_TRANSLATION = "(c)";
    private static final String TRADEMARK_CODE = "#8482";
    private static final String TRADEMARK_TRANSLATION = "(tm)";
    private static final String REGISTERED_CODE = "#174";
    private static final String REGISTERED_TRANSLATION = "(r)";
    private static final String DASH_CODE = "#8211";
    private static final String DASH_TRANSLATION = "-";
    private static final String SIMPLEQUOTE_CODE = "#8217";
    private static final String SIMPLEQUOTE2_CODE = "#8249";
    private static final String SIMPLEQUOTE3_CODE = "#8250";
    private static final String SIMPLEQUOTE4_CODE = "#8216";
    private static final String SIMPLEQUOTE_TRANSLATION = "'";
    private static final String LEFTDOUBLEQUOTE_CODE = "#171";
    private static final String LEFTDOUBLEQUOTE1_CODE = "#8220";
    private static final String LEFTDOUBLEQUOTE_TRANSLATION = "\"";
    private static final String RIGHTDOUBLEQUOTE_CODE = "#187";
    private static final String RIGHTDOUBLEQUOTE1_CODE = "#8221";
    private static final String RIGHTDOUBLEQUOTE_TRANSLATION = "\"";
    private static final String TABULATION_SYMBOL = "<dd/>";
    private static final String TABULATION_TRANSLATION = "<dd/>";
    private static Map<String, String> entityMapping = new HashMap<String, String>();

    private EntitySerializer() {
    }

    public static String render(Entity entity) {
        EntitySerializer.initializeEntityMapping();
        if (entityMapping.containsKey(entity.getData())) {
            return entityMapping.get(entity.getData());
        }
        return entity.getData();
    }

    private static void initializeEntityMapping() {
        if (entityMapping.isEmpty()) {
            entityMapping.put(COPYRIGHT_CODE, COPYRIGHT_TRANSLATION);
            entityMapping.put(TRADEMARK_CODE, TRADEMARK_TRANSLATION);
            entityMapping.put(REGISTERED_CODE, REGISTERED_TRANSLATION);
            entityMapping.put(DASH_CODE, DASH_TRANSLATION);
            entityMapping.put(SIMPLEQUOTE_CODE, SIMPLEQUOTE_TRANSLATION);
            entityMapping.put(SIMPLEQUOTE2_CODE, SIMPLEQUOTE_TRANSLATION);
            entityMapping.put(SIMPLEQUOTE3_CODE, SIMPLEQUOTE_TRANSLATION);
            entityMapping.put(SIMPLEQUOTE4_CODE, SIMPLEQUOTE_TRANSLATION);
            entityMapping.put(LEFTDOUBLEQUOTE_CODE, "\"");
            entityMapping.put(LEFTDOUBLEQUOTE1_CODE, "\"");
            entityMapping.put(RIGHTDOUBLEQUOTE_CODE, "\"");
            entityMapping.put(RIGHTDOUBLEQUOTE1_CODE, "\"");
            entityMapping.put("<dd/>", "<dd/>");
        }
    }
}

