/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.typeListener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeNotificator
implements Notificator {
    private Set<RepositoryObjectHandler> listeningHandlers;
    private Set<EStructuralFeature> listenedTypes;

    public TypeNotificator(Set<EStructuralFeature> listenedTypes) {
        this.listenedTypes = listenedTypes;
        this.listeningHandlers = new LinkedHashSet<RepositoryObjectHandler>();
    }

    public TypeNotificator(Set<EStructuralFeature> listenedTypes, Set<RepositoryObjectHandler> listeningHandlers) {
        this.listenedTypes = listenedTypes;
        this.listeningHandlers = new LinkedHashSet<RepositoryObjectHandler>();
        for (RepositoryObjectHandler listeningHandler : listeningHandlers) {
            this.addRepositoryObjectHandler(listeningHandler);
        }
    }

    @Override
    public void stop() {
        for (RepositoryObjectHandler handler : this.listeningHandlers) {
            this.removeRepositoryObjectHandler(handler);
        }
    }

    @Override
    public void addRepositoryObjectHandler(RepositoryObjectHandler listener) {
        this.listeningHandlers.add(listener);
        if (listener.getRepositoryAdapter() != null) {
            listener.getRepositoryAdapter().attachSessionListenerForTypes(this, this.listenedTypes);
        }
    }

    @Override
    public void removeRepositoryObjectHandler(RepositoryObjectHandler listener) {
        if (listener.getRepositoryAdapter() != null) {
            listener.getRepositoryAdapter().detachSessionListenerForTypes(this);
        }
        this.listeningHandlers.remove(listener);
    }

    @Override
    public void notifyHandlers(RepositoryChangeNotification changeNotification) {
        for (RepositoryObjectHandler handler : this.listeningHandlers) {
            handler.handleChangeNotification(changeNotification);
        }
    }

    public static List<EStructuralFeature> getStructuralFeaturesForEClass(EClass eClass) {
        ArrayList<EStructuralFeature> classFeatures = new ArrayList<EStructuralFeature>();
        classFeatures.addAll((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        return classFeatures;
    }

    @Override
    public void addObjectsToListen(List<EObject> objectsToHandle) {
        throw new UnsupportedOperationException("A type Notificator cannot be dynamicly changed");
    }

    @Override
    public void removeObjectsToListen(List<Object> objectsToRemove) {
        throw new UnsupportedOperationException("A type Notificator cannot be dynamicly changed");
    }
}

