/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.generatedelementlistener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEGeneratedElementListenerDeltaVisitor
implements IResourceDeltaVisitor {
    protected Collection<URI> changedResources;
    protected Collection<URI> removedResources;
    protected Set<URI> listenedElementsURIs;

    public IDEGeneratedElementListenerDeltaVisitor(Set<URI> listenedElementsURIs) {
        this.listenedElementsURIs = listenedElementsURIs;
        this.changedResources = new ArrayList<URI>();
        this.removedResources = new ArrayList<URI>();
    }

    public boolean visit(IResourceDelta delta) {
        String uri;
        URI changedResourceURI;
        if (delta.getResource().getType() != 1) {
            return true;
        }
        if (this.isRelevantModification(delta) && (changedResourceURI = URI.createPlatformResourceURI((String)(uri = delta.getFullPath().toString()), (boolean)false)) != null && this.listenedElementsURIs.contains(changedResourceURI)) {
            switch (delta.getKind()) {
                case 2: {
                    this.removedResources.add(changedResourceURI);
                    break;
                }
                case 1: 
                case 4: {
                    this.changedResources.add(changedResourceURI);
                    break;
                }
            }
        }
        return true;
    }

    protected boolean isRelevantModification(IResourceDelta delta) {
        boolean isRelevantModification = delta.getKind() == 2 || delta.getKind() == 4 || delta.getKind() == 1;
        isRelevantModification = isRelevantModification && delta.getFlags() != 131072;
        return isRelevantModification;
    }

    public Collection<URI> getChangedResources() {
        return this.changedResources;
    }

    public Collection<URI> getRemovedResources() {
        return this.removedResources;
    }
}

