/*
 * Copyright 2013, 2020 International Business Machines Corp. and others
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */
package com.ibm.jbatch.tck.utils;

import java.util.Date;
import java.util.Properties;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;

public class TCKJobExecutionWrapper implements TCKJobExecution {

    private JobExecution jobExecution = null;
    private JobOperator jobOp = null;

    public TCKJobExecutionWrapper(JobExecution jobExecution, JobOperator jobOp) {
        this.jobExecution = jobExecution;
        this.jobOp = jobOp;
    }

    @Override
    public long getExecutionId() {
        return jobExecution.getExecutionId();
    }

    @Override
    public String getJobName() {
        return jobExecution.getJobName();
    }

    @Override
    public BatchStatus getBatchStatus() {
        return jobExecution.getBatchStatus();
    }

    @Override
    public Date getStartTime() {
        return jobExecution.getStartTime();
    }

    @Override
    public Date getEndTime() {
        return jobExecution.getEndTime();
    }

    @Override
    public String getExitStatus() {
        return jobExecution.getExitStatus();
    }

    @Override
    public Date getCreateTime() {
        return jobExecution.getCreateTime();
    }

    @Override
    public Date getLastUpdatedTime() {
        return jobExecution.getLastUpdatedTime();
    }

    @Override
    public Properties getJobParameters() {
        return jobExecution.getJobParameters();
    }

    @Override
    public long getInstanceId() throws NoSuchJobExecutionException, JobSecurityException {
        long jobExecutionId = jobExecution.getExecutionId();
        JobInstance jobInstance = jobOp.getJobInstance(jobExecutionId);
        return jobInstance.getInstanceId();
    }

}
