/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class StartLimitTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @Test
    public void testStartLimitVariation1() throws Exception {
        String METHOD = "testStartLimitVariation1";
        try {
            long lastExecutionId = 0L;
            TCKJobExecutionWrapper exec = null;
            String[] expectedExitStatuses = new String[]{"c1,c2,x3", "c1,c2,x3", "c1,c2,x3", "c1,c2"};
            for (int i = 1; i <= 4; ++i) {
                String execString = new Integer(i).toString();
                Properties jobParameters = new Properties();
                jobParameters.put("execution.number", execString);
                jobParameters.put("batchlet.ref", "startLimitStateMachineVariation1Batchlet");
                if (i == 1) {
                    Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
                    exec = jobOp.startJobAndWaitForResult("startLimitTests", jobParameters);
                } else {
                    Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
                    exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParameters);
                }
                lastExecutionId = exec.getExecutionId();
                Reporter.log((String)("Execution #" + i + " JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
                Reporter.log((String)("Execution #" + i + " JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
                AssertionUtils.assertWithMessage("Testing execution #" + i, expectedExitStatuses[i - 1], exec.getExitStatus());
                AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.FAILED, exec.getBatchStatus());
                List<StepExecution> steps = jobOp.getStepExecutions(lastExecutionId);
                if (i >= 1 && i <= 3) {
                    AssertionUtils.assertWithMessage("Found 3 step executions", 3, steps.size());
                } else {
                    AssertionUtils.assertWithMessage("Found 2 step executions", 2, steps.size());
                }
                for (StepExecution step : steps) {
                    if (step.getStepName().equals("step1")) {
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step1: ", BatchStatus.COMPLETED, step.getBatchStatus());
                        continue;
                    }
                    if (step.getStepName().equals("step2")) {
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step2: ", BatchStatus.COMPLETED, step.getBatchStatus());
                        continue;
                    }
                    if (step.getStepName().equals("step3")) {
                        AssertionUtils.assertWithMessage("Shouldn't have a StepExecution for step 3 on execution #4", i != 4);
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step3: ", BatchStatus.FAILED, step.getBatchStatus());
                        continue;
                    }
                    throw new IllegalStateException("Shouldn't get here, unknown step");
                }
            }
        }
        catch (Exception e) {
            StartLimitTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testStartLimitVariation2() throws Exception {
        String METHOD = "testStartLimitVariation2";
        try {
            long lastExecutionId = 0L;
            TCKJobExecutionWrapper exec = null;
            String[] expectedExitStatuses = new String[]{"c1,c2,x3", "c1,c2,x3", "c1,c2,s3", "c1,c2,s4", "f4", "c1,c2,c4,f5", "c1,c2"};
            for (int i = 1; i <= 7; ++i) {
                String execString = new Integer(i).toString();
                Properties jobParameters = new Properties();
                jobParameters.put("execution.number", execString);
                jobParameters.put("batchlet.ref", "startLimitStateMachineVariation2Batchlet");
                if (i >= 4) {
                    jobParameters.put("stop.after.step.3", "DON'T_MATCH_ME");
                }
                if (i >= 5) {
                    jobParameters.put("stop.after.step.4", "DON'T_MATCH_ME");
                }
                if (i == 1) {
                    Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
                    exec = jobOp.startJobAndWaitForResult("startLimitTests", jobParameters);
                } else {
                    Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
                    exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParameters);
                }
                lastExecutionId = exec.getExecutionId();
                Reporter.log((String)("Execution #" + i + " JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
                Reporter.log((String)("Execution #" + i + " JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
                AssertionUtils.assertWithMessage("Testing execution #" + i, expectedExitStatuses[i - 1], exec.getExitStatus());
                if (i == 1 || i == 2 || i == 5 || i == 6 || i == 7) {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.FAILED, exec.getBatchStatus());
                } else if (i == 3 || i == 4) {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.STOPPED, exec.getBatchStatus());
                }
                List<StepExecution> steps = jobOp.getStepExecutions(lastExecutionId);
                if (i >= 1 && i <= 4) {
                    AssertionUtils.assertWithMessage("Found 3 step executions", 3, steps.size());
                } else if (i == 5) {
                    AssertionUtils.assertWithMessage("Found 1 step executions", 1, steps.size());
                } else if (i == 6) {
                    AssertionUtils.assertWithMessage("Found 4 step executions", 4, steps.size());
                } else if (i == 7) {
                    AssertionUtils.assertWithMessage("Found 2 step executions", 2, steps.size());
                }
                for (StepExecution step : steps) {
                    if (step.getStepName().equals("step1")) {
                        AssertionUtils.assertWithMessage("Shouldn't have a StepExecution for step 1 on execution #5, i= " + i, i != 5);
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step1: ", BatchStatus.COMPLETED, step.getBatchStatus());
                        continue;
                    }
                    if (step.getStepName().equals("step2")) {
                        AssertionUtils.assertWithMessage("Shouldn't have a StepExecution for step 1 on execution #5, i = " + i, i != 5);
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step2: ", BatchStatus.COMPLETED, step.getBatchStatus());
                        continue;
                    }
                    if (step.getStepName().equals("step3")) {
                        AssertionUtils.assertWithMessage("Should only have a StepExecution for step 3 on executions #1,2,3, i= " + i, i <= 3);
                        if (i <= 2) {
                            AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step3: ", BatchStatus.FAILED, step.getBatchStatus());
                            continue;
                        }
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step3: ", BatchStatus.COMPLETED, step.getBatchStatus());
                        continue;
                    }
                    if (step.getStepName().equals("step4")) {
                        AssertionUtils.assertWithMessage("Should only have a StepExecution for step 4 on executions #4,5,6, i = " + i, i >= 4 && i <= 6);
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step4: ", BatchStatus.COMPLETED, step.getBatchStatus());
                        continue;
                    }
                    if (step.getStepName().equals("step5")) {
                        AssertionUtils.assertWithMessage("Should only have a StepExecution for step 5 on execution #6, i = " + i, i == 6);
                        AssertionUtils.assertWithMessage("Testing step execution #" + i + ", step5: ", BatchStatus.COMPLETED, step.getBatchStatus());
                        continue;
                    }
                    throw new IllegalStateException("Shouldn't get here, unknown step");
                }
            }
        }
        catch (Exception e) {
            StartLimitTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testStartLimitVariation3() throws Exception {
        String METHOD = "testStartLimitVariation3";
        try {
            long lastExecutionId = 0L;
            TCKJobExecutionWrapper exec = null;
            String[] expectedExitStatuses = new String[]{"c1,c2,c3,c4,s5", "f5", "c1,c2,c4,c5"};
            for (int i = 1; i <= 3; ++i) {
                String execString = new Integer(i).toString();
                Properties jobParameters = new Properties();
                jobParameters.put("execution.number", execString);
                jobParameters.put("batchlet.ref", "startLimitStateMachineVariation3Batchlet");
                if (i == 1) {
                    Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
                    exec = jobOp.startJobAndWaitForResult("startLimitTests", jobParameters);
                } else {
                    Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
                    exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParameters);
                }
                lastExecutionId = exec.getExecutionId();
                Reporter.log((String)("Execution #" + i + " JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
                Reporter.log((String)("Execution #" + i + " JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
                AssertionUtils.assertWithMessage("Testing execution #" + i, expectedExitStatuses[i - 1], exec.getExitStatus());
                if (i == 1) {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.STOPPED, exec.getBatchStatus());
                } else if (i == 2) {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.FAILED, exec.getBatchStatus());
                } else {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.COMPLETED, exec.getBatchStatus());
                }
                List<StepExecution> steps = jobOp.getStepExecutions(lastExecutionId);
                if (i == 1) {
                    AssertionUtils.assertWithMessage("Found 5 step executions", 5, steps.size());
                } else if (i == 2) {
                    AssertionUtils.assertWithMessage("Found 1 step execution", 1, steps.size());
                } else {
                    AssertionUtils.assertWithMessage("Found 4 step execution", 4, steps.size());
                }
                for (StepExecution step : steps) {
                    AssertionUtils.assertWithMessage("Testing step execution #" + i + ", stepName = " + step.getStepName(), BatchStatus.COMPLETED, step.getBatchStatus());
                }
            }
        }
        catch (Exception e) {
            StartLimitTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

