/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.utils;

import com.ibm.jbatch.tck.utils.BeanDefinition;
import jakarta.inject.Named;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchXMLGenerator {
    private static final Logger logger = Logger.getLogger(BatchXMLGenerator.class.getName());
    private static final String SLASH = System.getProperty("file.separator");
    List<BeanDefinition> beanDefinitions = new ArrayList<BeanDefinition>();

    private void writeBatchXML(File dir) {
        try {
            File batchXMLFile = new File(dir, "batch.xml");
            logger.info("Writing batch.xml: " + String.valueOf(batchXMLFile));
            BufferedWriter writer = new BufferedWriter(new FileWriter(batchXMLFile));
            writer.write("<batch-artifacts xmlns=\"https://jakarta.ee/xml/ns/jakartaee\">\n");
            for (BeanDefinition beanDef : this.beanDefinitions) {
                writer.write("    " + beanDef.getXMLString() + "\n");
            }
            writer.write("</batch-artifacts>\n");
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String generateId(String qualifiedClassName) {
        String retVal = null;
        int index = qualifiedClassName.lastIndexOf(".");
        String simpleName = qualifiedClassName.substring(index + 1);
        String simpleNameFirst = simpleName.substring(0, 1).toLowerCase();
        String simpleNameRest = simpleName.substring(1);
        retVal = simpleNameFirst + simpleNameRest;
        return retVal;
    }

    private void processClass(String qualifiedClassName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing class: " + qualifiedClassName);
        }
        String namedAnnotationValue = null;
        Class<?> artifactClass = null;
        try {
            artifactClass = Class.forName(qualifiedClassName);
            boolean isBatchArtifact = this.isBatchArtifact(artifactClass);
            if (!isBatchArtifact) {
                return;
            }
            Named namedAnnotation = artifactClass.getAnnotation(Named.class);
            if (namedAnnotation != null) {
                namedAnnotationValue = namedAnnotation.value();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        String beanID = null;
        beanID = namedAnnotationValue != null && !namedAnnotationValue.trim().isEmpty() && !namedAnnotationValue.startsWith("CDI") ? namedAnnotationValue : this.generateId(qualifiedClassName);
        BeanDefinition beanXML = new BeanDefinition(beanID, qualifiedClassName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding bean to batch.xml: beanId=" + beanID + " className=" + qualifiedClassName);
        }
        this.beanDefinitions.add(beanXML);
    }

    private boolean isBatchArtifact(Class artifactClass) {
        if (artifactClass == null) {
            logger.fine("End of the line, returning false.");
            return false;
        }
        Class<?>[] interfaces = artifactClass.getInterfaces();
        if (interfaces.length == 0) {
            logger.fine("No batch interfaces found for class: " + artifactClass.getCanonicalName() + ", since it doesn't implement any interfaces. Will try superclass (if one exists).");
            return this.isBatchArtifact(artifactClass.getSuperclass());
        }
        for (Class<?> interfaze : interfaces) {
            if (!interfaze.getCanonicalName().startsWith("jakarta.batch")) continue;
            logger.fine("Found a batch interface found for class: " + artifactClass.getCanonicalName() + ".  Continuing to add this entry to batch.xml");
            return true;
        }
        logger.fine("No batch interfaces found for class: " + artifactClass.getCanonicalName() + ".  Will try superclass (if one exists).");
        return this.isBatchArtifact(artifactClass.getSuperclass());
    }

    private static List<String> findClasses(String dir, String prefix) {
        File directory = new File(dir, prefix);
        logger.info("Searching : " + String.valueOf(directory));
        if (!directory.exists()) {
            throw new IllegalArgumentException("This directory does not exist: " + directory.toString());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("This is not a directory: " + directory.toString());
        }
        ArrayList<String> classList = new ArrayList<String>();
        BatchXMLGenerator.findClasses(directory, prefix, classList);
        return classList;
    }

    private static void findClasses(File directory, String path, List<String> classList) {
        logger.info("Searching : " + String.valueOf(directory));
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String filename;
            if (file.isDirectory()) {
                String nextPath = path.endsWith(SLASH) ? path + file.getName() + SLASH : path + SLASH + file.getName() + SLASH;
                BatchXMLGenerator.findClasses(file, nextPath, classList);
            }
            if (!(filename = file.getName()).endsWith(".class")) continue;
            String classname = filename.substring(0, filename.lastIndexOf("."));
            String fqcn = path.replace(SLASH, ".") + classname;
            logger.info("Found " + fqcn);
            classList.add(fqcn);
        }
    }

    public static void main(String[] args) {
        logger.info("Starting BatchXMLGenerator");
        String srcDir = args[0];
        String startSearchAt = args[1];
        String outputDir = args[2];
        BatchXMLGenerator bxg = new BatchXMLGenerator();
        File src = new File(srcDir, startSearchAt);
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("First and second arguments '" + srcDir + "' and '" + startSearchAt + "'\nmust combine to be a directory where the second argument is the directories that form the package name.\n e.g. arg[0] = ${PROJECT_ROOT}/target/classes\n      arg[1] = com/ibm/jbatch/tck/artifacts\n Found: " + String.valueOf(src));
        }
        File batchXMLDir = new File(outputDir);
        if (!batchXMLDir.isDirectory()) {
            throw new IllegalArgumentException("Third argument must be a directory. Found: '" + outputDir + "'.");
        }
        List<String> classList = BatchXMLGenerator.findClasses(srcDir, startSearchAt);
        for (String className : classList) {
            bxg.processClass(className);
        }
        bxg.writeBatchXML(batchXMLDir);
        logger.info("BatchXMLGenerator completed successfully.");
    }
}

