/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.select;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Animal;
import ee.jakarta.tck.nosql.factories.AnimalListSupplier;
import java.util.List;
import java.util.logging.Logger;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The query execution using MappedSuperclass annotation")
public class SelectMappedSuperclassTest
extends AbstractTemplateTest {
    private static final Logger LOGGER = Logger.getLogger(SelectMappedSuperclassTest.class.getName());

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with no conditions")
    void shouldSelectWithNoConditions(List<Animal> animals) {
        animals.forEach(animal -> this.template.insert(animal));
        try {
            List result = this.template.select(Animal.class).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).hasSize(animals.size());
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with simple conditions")
    void shouldSelectWithSimpleConditions(List<Animal> animals) {
        animals.forEach(animal -> this.template.insert(animal));
        try {
            List result = this.template.select(Animal.class).where("name").eq((Object)animals.get(0).getName()).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).allMatch(animal -> animal.getName().equals(((Animal)animals.get(0)).getName()));
            });
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with 'greater-than' condition")
    void shouldSelectWithGreaterThanCondition(List<Animal> animals) {
        try {
            animals.forEach(animal -> this.template.insert(animal));
            int secondElder = animals.stream().mapToInt(Animal::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Animal.class).where("age").gt((Object)secondElder).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).allMatch(animal -> animal.getAge() > secondElder);
            });
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with 'less-than' condition")
    void shouldSelectWithLessThanCondition(List<Animal> animals) {
        try {
            animals.forEach(animal -> this.template.insert(animal));
            int secondElder = animals.stream().mapToInt(Animal::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Animal.class).where("age").lt((Object)secondElder).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).allMatch(animal -> animal.getAge() < secondElder);
            });
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with LIKE condition")
    void shouldSelectWithLikeCondition(List<Animal> animals) {
        try {
            animals.forEach(animal -> this.template.insert(animal));
            List result = this.template.select(Animal.class).where("name").like(animals.get(0).getName()).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).allMatch(animal -> animal.getName().contains(((Animal)animals.get(0)).getName()));
            });
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with 'in' condition")
    void shouldSelectWithInCondition(List<Animal> animals) {
        try {
            animals.forEach(animal -> this.template.insert(animal));
            List result = this.template.select(Animal.class).where("name").in(List.of(animals.get(0).getName())).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).allMatch(animal -> animal.getName().equals(((Animal)animals.get(0)).getName()));
            });
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with 'between' condition")
    void shouldSelectWithBetweenCondition(List<Animal> animals) {
        try {
            animals.forEach(animal -> this.template.insert(animal));
            Integer age = animals.stream().map(Animal::getAge).sorted().findFirst().orElse(0);
            LOGGER.info("Min age: " + age);
            List result = this.template.select(Animal.class).where("age").between((Object)age, (Object)(age + 10)).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).allMatch(animal -> animal.getAge() >= age && animal.getAge() <= age + 10);
            });
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should select animals with 'skip' and 'limit' conditions")
    void shouldSelectWithSkipAndLimitCondition(List<Animal> animals) {
        try {
            animals.forEach(animal -> this.template.insert(animal));
            int secondOlder = animals.stream().mapToInt(Animal::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Animal.class).where("age").gt((Object)secondOlder).skip(0L).limit(10L).result();
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat(result).isNotEmpty();
                soft.assertThat(result).allMatch(animal -> animal.getAge() > secondOlder);
            });
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }
}

