/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.ext.types;

import java.io.File;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.polarsys.kitalpha.richtext.widget.tools.ext.internal.Activator;
import org.polarsys.kitalpha.richtext.widget.tools.intf.LinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class AbsoluteFileLinkHandler
implements LinkHandler {
    public boolean canHandleLink(String link) {
        return link != null && link.contains("file:");
    }

    public void openLink(Object object, String link) {
        File fileToOpen = new File(link);
        if (fileToOpen.exists() && fileToOpen.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            FileStoreEditorInput editorInput = new FileStoreEditorInput(fileStore);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.openEditor((IEditorInput)editorInput, "org.eclipse.ui.systemExternalEditor");
            }
            catch (Exception e) {
                Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget.tools.ext", "openLink(" + link + ")", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public Tuple<String, String> getLink(String linkType, String basePath, Object object) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        dialog.setFilterPath(basePath);
        String attachFile = dialog.open();
        if (attachFile != null && attachFile.length() > 0) {
            try {
                File file = new File(dialog.getFilterPath(), dialog.getFileName());
                return new Tuple((Object)file.getAbsolutePath(), null);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget.tools.ext", "getURI(...)", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    public String encode(String url, String urlDisplayName) {
        return "<a href=\"file:///" + url.replace("\\", "\\\\") + "\">" + StringEscapeUtils.escapeHtml((String)urlDisplayName).replace("\\", "\\\\") + "</a>";
    }

    public String decode(String url, String basePath) {
        url = url.replaceFirst("file://", "");
        url = url.replace('/', '\\');
        url = url.replace("%20", " ");
        return url;
    }
}

