/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class OpenQuoteExpectedCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, XMLFormattingOptions formattingSettings, IComponentProvider componentProvider) {
        Position codeactionPosition;
        int offset;
        Range diagnosticRange = diagnostic.getRange();
        try {
            offset = document.offsetAt(diagnosticRange.getEnd());
        }
        catch (BadLocationException e) {
            return;
        }
        DOMAttr attr = document.findAttrAt(offset);
        if (attr == null || !attr.isAttribute()) {
            return;
        }
        String q = formattingSettings.getQuotationAsString();
        Position possibleEndPosition = null;
        String possibleValue = null;
        try {
            DOMAttr nextAttr;
            codeactionPosition = document.positionAt(attr.getEnd());
            DOMNode next = attr.getNextSibling();
            if (next instanceof DOMAttr && !(nextAttr = (DOMAttr)next).hasDelimiter()) {
                possibleEndPosition = document.positionAt(nextAttr.getEnd());
                possibleValue = nextAttr.getName();
            }
        }
        catch (BadLocationException e) {
            return;
        }
        CodeAction removeContentAction = possibleEndPosition != null && possibleValue != null ? CodeActionFactory.replace("Insert quotations", new Range(codeactionPosition, possibleEndPosition), q + possibleValue + q, document.getTextDocument(), diagnostic) : CodeActionFactory.insert("Insert quotations", codeactionPosition, q + q, document.getTextDocument(), diagnostic);
        codeActions.add(removeContentAction);
    }
}

