/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.uriresolver;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.uriresolver.IExternalSchemaLocationProvider;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class XMLFileAssociationResolverExtension
implements URIResolverExtension,
IExternalSchemaLocationProvider {
    private static Logger LOGGER = Logger.getLogger(XMLFileAssociationResolverExtension.class.getName());
    private String rootUri;
    private XMLFileAssociation[] fileAssociations;

    public boolean setFileAssociations(XMLFileAssociation[] fileAssociations) {
        Object[] oldFileAssociations = this.fileAssociations;
        this.fileAssociations = fileAssociations;
        this.expandSystemId();
        return !Arrays.equals(oldFileAssociations, fileAssociations);
    }

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        if (systemId != null) {
            return null;
        }
        if (this.fileAssociations != null) {
            for (XMLFileAssociation fileAssociation : this.fileAssociations) {
                if (!fileAssociation.matches(baseLocation)) continue;
                return fileAssociation.getSystemId();
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getExternalSchemaLocation(URI fileURI) {
        if (this.fileAssociations != null) {
            for (XMLFileAssociation fileAssociation : this.fileAssociations) {
                if (!fileAssociation.matches(fileURI)) continue;
                return fileAssociation.getExternalSchemaLocation();
            }
        }
        return null;
    }

    public void setRootUri(String rootUri) {
        this.rootUri = rootUri;
    }

    private void expandSystemId() {
        if (this.fileAssociations != null) {
            for (XMLFileAssociation fileAssociation : this.fileAssociations) {
                try {
                    String expandSystemId = XMLEntityManager.expandSystemId((String)fileAssociation.getSystemId(), (String)this.rootUri, (boolean)false);
                    if (expandSystemId == null) continue;
                    fileAssociation.setSystemId(expandSystemId);
                }
                catch (URI.MalformedURIException e) {
                    LOGGER.log(Level.WARNING, "Issue expanding the provided systemId from the file associations.", e);
                }
            }
        }
    }
}

