/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.xsi.XSISchemaModel;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.Range;
import org.junit.jupiter.api.Test;

public class XMLSchemaHoverExtensionsTest {
    @Test
    public void testTagHover() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("spring-beans-3.0.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bea|n>";
        XMLSchemaHoverExtensionsTest.assertHover(xml, "Defines a single (usually named) bean. A bean definition may contain nested tags for constructor arguments, property values, lookup methods, and replaced methods. Mixing constructor injection and setter injection on the same bean is explicitly supported." + System.lineSeparator() + System.lineSeparator() + "Source: [spring-beans-3.0.xsd](" + schemaURI + ")", XMLAssert.r(2, 2, 2, 6));
    }

    @Test
    public void testAttributeNameHover() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("spring-beans-3.0.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean clas|s=>";
        XMLSchemaHoverExtensionsTest.assertHover(xml, "The fully qualified name of the bean's class, except if it serves only as a parent definition for child bean definitions." + System.lineSeparator() + System.lineSeparator() + "Source: [spring-beans-3.0.xsd](" + schemaURI + ")", XMLAssert.r(2, 7, 2, 12));
    }

    @Test
    public void testTagHoverFromXSType() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("invoice.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoi|ce xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"http://invoice xsd/invoice.xsd \">\r\n";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", "An invoice type..." + System.lineSeparator() + System.lineSeparator() + "Source: [invoice.xsd](" + schemaURI + ")", XMLAssert.r(1, 1, 1, 8));
    }

    @Test
    public void testTagHoverForSchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schema|Location=\"http://invoice xsd/invoice.xsd \">\r\n";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", XSISchemaModel.SCHEMA_LOCATION_DOC, XMLAssert.r(2, 1, 2, 19));
    }

    @Test
    public void testTagHoverForNoNamespaceSchemaLocation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespace|SchemaLocation=\"http://invoice xsd/invoice.xsd \">\r\n";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", XSISchemaModel.NO_NAMESPACE_SCHEMA_LOCATION_DOC, XMLAssert.r(2, 1, 2, 30));
    }

    @Test
    public void testTagHoverForXSInil() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:n|il=\"http://invoice xsd/invoice.xsd \">\r\n";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", "Indicates if an element should contain content. Valid values are `true` or `false`", XMLAssert.r(2, 1, 2, 8));
    }

    @Test
    public void testTagHoverForXSIType() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:ty|pe=\"http://invoice xsd/invoice.xsd \">\r\n";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", "Specifies the type of an element. This attribute labels an element as a particular type, even though there might not be an element declaration in the schema binding that element to the type.", XMLAssert.r(2, 1, 2, 9));
    }

    @Test
    public void testTagHoverForXSIType2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n x|si:type=\"http://invoice xsd/invoice.xsd \">\r\n";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", "Specifies the type of an element. This attribute labels an element as a particular type, even though there might not be an element declaration in the schema binding that element to the type.", XMLAssert.r(2, 1, 2, 9));
    }

    @Test
    public void testTagHoverForXSIBadPrefix() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n BAD:t|ype=\"http://invoice xsd/invoice.xsd \">\r\n";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", null, XMLAssert.r(3, 2, 3, 6));
    }

    @Test
    public void testTagHoverForXSITypeNotRoot() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n>\r\n<a xsi:ty|pe=\"\"></a>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", "Specifies the type of an element. This attribute labels an element as a particular type, even though there might not be an element declaration in the schema binding that element to the type.", XMLAssert.r(3, 3, 3, 11));
    }

    @Test
    public void testTagHoverForXSINILNotRoot() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n>\r\n<a xsi:n|il=\"\"></a>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", "Indicates if an element should contain content. Valid values are `true` or `false`", XMLAssert.r(3, 3, 3, 10));
    }

    @Test
    public void testTagHoverForXSISchemaNotRoot() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n>\r\n<a xsi:noNamespa|ceSchemaLocation\"\"></a>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/invoice.xml", null, XMLAssert.r(3, 2, 3, 6));
    }

    @Test
    public void testHoverAttributeValueEuro() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("money.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<money xmlns=\"http://money\" currency=\"eu|ros\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://money xsd/money.xsd\"></money>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/money.xml", "Euro Hover" + System.lineSeparator() + System.lineSeparator() + "Source: [money.xsd](" + schemaURI + ")", XMLAssert.r(1, 37, 1, 44));
    }

    @Test
    public void testHoverAttributeValuePound() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("money.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<money xmlns=\"http://money\" currency=\"pou|nds\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://money xsd/money.xsd\"></money>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/money.xml", "Pound Hover" + System.lineSeparator() + System.lineSeparator() + "Source: [money.xsd](" + schemaURI + ")", XMLAssert.r(1, 37, 1, 45));
    }

    @Test
    public void testHoverAttributeValueNonExistent() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("money.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<money xmlns=\"http://money\" curr|ency=\"pounds\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://money xsd/money.xsd\"></money>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/money.xml", "Currency name Hover" + System.lineSeparator() + System.lineSeparator() + "Source: [money.xsd](" + schemaURI + ")", XMLAssert.r(1, 28, 1, 36));
    }

    @Test
    public void hoverCacheBug() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("money.xsd");
        XMLLanguageService ls = new XMLLanguageService();
        String xmlAttNameHover = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<money xmlns=\"http://money\" curr|ency=\"pounds\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://money xsd/money.xsd\"></money>";
        XMLAssert.assertHover(ls, xmlAttNameHover, null, "src/test/resources/money.xml", "Currency name Hover" + System.lineSeparator() + System.lineSeparator() + "Source: [money.xsd](" + schemaURI + ")", XMLAssert.r(1, 28, 1, 36));
        String xmlAttValueHover = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<money xmlns=\"http://money\" currency=\"po|unds\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://money xsd/money.xsd\"></money>";
        XMLAssert.assertHover(ls, xmlAttValueHover, null, "src/test/resources/money.xml", "Pound Hover" + System.lineSeparator() + System.lineSeparator() + "Source: [money.xsd](" + schemaURI + ")", XMLAssert.r(1, 37, 1, 45));
    }

    @Test
    public void hoverAttributeValueWithUnion() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("dressSize.xsd");
        String xml = "<dress\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\"\r\n\tsize=\"sma|ll\" />";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/dress.xml", "Small documentation" + System.lineSeparator() + System.lineSeparator() + "Source: [dressSize.xsd](" + schemaURI + ")", XMLAssert.r(3, 6, 3, 13));
    }

    @Test
    public void hoverAttributeValueWithUnion2() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("dressSize.xsd");
        String xml = "<dress\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\"\r\n\tsize=\"lar|ge\" />";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/dress.xml", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: [dressSize.xsd](" + schemaURI + ")", XMLAssert.r(3, 6, 3, 13));
    }

    @Test
    public void hoverTextWithUnion() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("dressSize.xsd");
        String xml = "<dresssize\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\" >\r\n\tsma|ll </dresssize>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/dress.xml", "Small documentation" + System.lineSeparator() + System.lineSeparator() + "Source: [dressSize.xsd](" + schemaURI + ")", XMLAssert.r(2, 52, 3, 7));
    }

    @Test
    public void hoverTextWithUnion2() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("dressSize.xsd");
        String xml = "<dresssize\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\" >\r\n\tlar|ge </dresssize>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/dress.xml", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: [dressSize.xsd](" + schemaURI + ")", XMLAssert.r(2, 52, 3, 7));
    }

    @Test
    public void hoverTextWithUnion3() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtensionsTest.getXMLSchemaFileURI("dressSize.xsd");
        String xml = "<dresssize\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\" >\r\n\tx-lar|ge </dresssize>";
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/dress.xml", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: [dressSize.xsd](" + schemaURI + ")", XMLAssert.r(2, 52, 3, 9));
    }

    private static void assertHover(String value, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        XMLAssert.assertHover(new XMLLanguageService(), value, "src/test/resources/catalogs/catalog.xml", null, expectedHoverLabel, expectedHoverRange);
    }

    private static String getXMLSchemaFileURI(String schemaURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }
}

