/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.DefinitionRequest;
import org.eclipse.lemminx.services.XMLTypeDefinition;
import org.eclipse.lemminx.services.extensions.IDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionRequest;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLDefinition {
    private static final Logger LOGGER = Logger.getLogger(XMLTypeDefinition.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLDefinition(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<? extends LocationLink> findDefinition(DOMDocument document, Position position, CancelChecker cancelChecker) {
        DefinitionRequest request = null;
        try {
            request = new DefinitionRequest(document, position, this.extensionsRegistry);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Failed creating TypeDefinitionRequest", e);
            return Collections.emptyList();
        }
        ArrayList<LocationLink> locations = new ArrayList<LocationLink>();
        for (IDefinitionParticipant participant : this.extensionsRegistry.getDefinitionParticipants()) {
            participant.findDefinition(request, locations, cancelChecker);
        }
        XMLDefinition.findStartEndTagDefinition(request, locations);
        return locations;
    }

    private static void findStartEndTagDefinition(IDefinitionRequest request, List<LocationLink> locations) {
        DOMElement element;
        DOMNode node = request.getNode();
        if (node != null && node.isElement() && (element = (DOMElement)node).hasStartTag() && element.hasEndTag()) {
            DOMDocument document = element.getOwnerDocument();
            Range startRange = XMLPositionUtility.selectStartTagName(element);
            Range endRange = XMLPositionUtility.selectEndTagName(element);
            int offset = request.getOffset();
            if (element.isInStartTag(offset)) {
                locations.add(new LocationLink(document.getDocumentURI(), endRange, endRange, startRange));
            } else if (element.isInEndTag(offset)) {
                locations.add(new LocationLink(document.getDocumentURI(), startRange, startRange, endRange));
            }
        }
    }
}

