/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

public class MarkdownConverter {
    private static final Logger LOGGER = Logger.getLogger(MarkdownConverter.class.getName());
    private static Remark remark;

    private MarkdownConverter() {
    }

    public static String convert(String html) {
        if (!StringUtils.isTagOutsideOfBackticks(html)) {
            return StringEscapeUtils.unescapeXml((String)html);
        }
        return StringEscapeUtils.unescapeJava((String)remark.convert(html));
    }

    static {
        Options options = new Options();
        options.tables = Options.Tables.CONVERT_TO_CODE_BLOCK;
        options.hardwraps = true;
        options.inlineLinks = true;
        options.autoLinks = true;
        options.reverseHtmlSmartPunctuation = true;
        options.fencedCodeBlocks = Options.FencedCodeBlocks.ENABLED_BACKTICK;
        remark = new Remark(options);
        try {
            Field cleanerField = Remark.class.getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
            Cleaner c = (Cleaner)cleanerField.get(remark);
            Field whitelistField = Cleaner.class.getDeclaredField("whitelist");
            whitelistField.setAccessible(true);
            Whitelist w = (Whitelist)whitelistField.get(c);
            w.addProtocols("a", "href", new String[]{"file"});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.severe("Unable to modify jsoup to include file protocols " + e.getMessage());
        }
    }
}

