/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class XMLSchemaPublishDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void schemaWithUrlWithoutCache() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(false);
        };
        String fileURI = "test.xml";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"http://invoice.xsd\">\r\n</invoice> \r\n";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, configuration, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 31, 2, 51), "schema_reference.4: Failed to read schema document 'http://invoice.xsd', because 1) could not find the document; 2) the document could not be read; 3) the root element of the document is not <xsd:schema>.", DiagnosticSeverity.Warning, "xml", "schema_reference.4"), new Diagnostic(XMLAssert.r(1, 1, 1, 8), "cvc-elt.1.a: Cannot find the declaration of element 'invoice'.", DiagnosticSeverity.Error, "xml", "cvc-elt.1.a")));
    }

    @Test
    public void schemaWithUrlWithoutCacheNoDuplicateWarning() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(false);
        };
        String fileURI = "test.xml";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"http://invoice.xsd\">\r\n  <a></a>\r\n  <b></b>\r\n  <c></c>\r\n</invoice> \r\n";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, configuration, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 31, 2, 51), "schema_reference.4: Failed to read schema document 'http://invoice.xsd', because 1) could not find the document; 2) the document could not be read; 3) the root element of the document is not <xsd:schema>.", DiagnosticSeverity.Warning, "xml", "schema_reference.4"), new Diagnostic(XMLAssert.r(1, 1, 1, 8), "cvc-elt.1.a: Cannot find the declaration of element 'invoice'.", DiagnosticSeverity.Error, "xml", "cvc-elt.1.a")));
    }

    @Test
    public void schemaWithUrlInvalidPathWithNamespace() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(false);
        };
        String fileURI = "test.xml";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"http://invoice.xsd\">\r\n</invoice> \r\n";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, configuration, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 20, 2, 40), "SchemaLocation: schemaLocation value = 'http://invoice.xsd' must have even number of URI's.", DiagnosticSeverity.Warning, "xml", "SchemaLocation"), new Diagnostic(XMLAssert.r(1, 1, 1, 8), "cvc-elt.1.a: Cannot find the declaration of element 'invoice'.", DiagnosticSeverity.Error, "xml", "cvc-elt.1.a")));
    }

    @Test
    public void schemaWithUrlWithCache() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(true);
        };
        String fileURI = "test.xml";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"http://invoice.xsd\">\r\n</invoice> \r\n";
        TimeUnit.SECONDS.sleep(2L);
        String expectedLocation = TEST_WORK_DIRECTORY.resolve("cache/http/invoice.xsd").toString();
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, configuration, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(1, 1, 1, 8), "The resource 'http://invoice.xsd' is downloading.", DiagnosticSeverity.Information, "xml")), XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(1, 1, 1, 8), "Error while downloading 'http://invoice.xsd' to " + expectedLocation + ".", DiagnosticSeverity.Error, "xml")));
    }

    @Test
    public void schemaWithUrlWithCacheAndWithCatalog() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(true);
            contentModelManager.setCatalogs(new String[]{"src/test/resources/catalogs/catalog.xml"});
        };
        String fileURI = "test.xml";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"http://invoice.xsd\">\r\n  <date>2017-11-30_INVALID</date>      \r\n  <number>5235</number> \r\n  <products>   \r\n    <product description=\"laptop\" price=\"700.00\"/>\r\n    <product description=\"mouse\" price=\"30.00\"  />\r\n  </products>\r\n  <payments> \r\n    <payment amount=\"770.00\" method=\"credit\"/>\r\n  </payments>\r\n</invoice> \r\n";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, configuration, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(3, 8, 3, 26), "Content of type 'date' is expected.\n\nThe following content is not a valid type:\n '2017-11-30_INVALID'\n\nCode:", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_datatype_valid_1_2_1.getCode()), new Diagnostic(XMLAssert.r(3, 8, 3, 26), "cvc-type.3.1.3: The value '2017-11-30_INVALID' of element 'date' is not valid.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_type_3_1_3.getCode())));
    }

    @Test
    public void schemaWithUrlWithoutCacheAndWithCatalog() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(false);
            contentModelManager.setCatalogs(new String[]{"src/test/resources/catalogs/catalog.xml"});
        };
        String fileURI = "test.xml";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"http://invoice.xsd\">\r\n  <date>2017-11-30_INVALID</date>      \r\n  <number>5235</number> \r\n  <products>   \r\n    <product description=\"laptop\" price=\"700.00\"/>\r\n    <product description=\"mouse\" price=\"30.00\"  />\r\n  </products>\r\n  <payments> \r\n    <payment amount=\"770.00\" method=\"credit\"/>\r\n  </payments>\r\n</invoice> \r\n";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, configuration, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(3, 8, 3, 26), "Content of type 'date' is expected.\n\nThe following content is not a valid type:\n '2017-11-30_INVALID'\n\nCode:", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_datatype_valid_1_2_1.getCode()), new Diagnostic(XMLAssert.r(3, 8, 3, 26), "cvc-type.3.1.3: The value '2017-11-30_INVALID' of element 'date' is not valid.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_type_3_1_3.getCode())));
    }
}

