/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.Location;
import org.junit.jupiter.api.Test;

public class DTDReferenceExtensionsTest {
    @Test
    public void referencesOnDTDElementName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT no|te (to,from,heading,body, note?)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>";
        this.testReferencesFor(xml, XMLAssert.l("test.xml", XMLAssert.r(2, 39, 2, 43)), XMLAssert.l("test.xml", XMLAssert.r(3, 11, 3, 15)));
    }

    @Test
    public void noReferencesAfterElementName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, note?|)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>";
        this.testReferencesFor(xml, new Location[0]);
    }

    @Test
    public void noReferencesAfterDTDAttrListName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, note?)>\r\n\t<!ATTLIST note version CD|ATA #REQUIRED>\r\n]>";
        this.testReferencesFor(xml, new Location[0]);
    }

    @Test
    public void noReferencesOnDTDAttListName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, note?)>\r\n\t<!ATTLIST no|te version CDATA #REQUIRED>\r\n]>";
        this.testReferencesFor(xml, new Location[0]);
    }

    @Test
    public void noReferencesOnDTDElementChildName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, no|te?)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>";
        this.testReferencesFor(xml, new Location[0]);
    }

    private void testReferencesFor(String xml, Location ... expectedItems) throws BadLocationException {
        XMLAssert.testReferencesFor(xml, "test.xml", expectedItems);
    }
}

