/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.opti.SchemaDOMParser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.AggregateRelatedInfoFinder;
import org.eclipse.lemminx.extensions.xerces.LSPMessageFormatter;
import org.eclipse.lemminx.extensions.xerces.ReflectionUtils;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.msg.XMLModelMessageFormatter;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public abstract class AbstractLSPErrorReporter
extends XMLErrorReporter {
    private static final Logger LOGGER = Logger.getLogger(AbstractLSPErrorReporter.class.getName());
    protected static final Range NO_RANGE = new Range();
    private final DOMDocument xmlDocument;
    private final List<Diagnostic> diagnostics;
    private final String source;
    private boolean hasRelatedInfo;

    public AbstractLSPErrorReporter(String source, DOMDocument xmlDocument, List<Diagnostic> diagnostics, boolean hasRelatedInfo) {
        this.source = source;
        this.xmlDocument = xmlDocument;
        this.diagnostics = diagnostics;
        this.hasRelatedInfo = hasRelatedInfo;
        XMLMessageFormatter xmft = new XMLMessageFormatter();
        super.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", (MessageFormatter)xmft);
        super.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", (MessageFormatter)xmft);
        super.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)new LSPMessageFormatter());
        super.putMessageFormatter("https://www.w3.org/TR/xml-model/", (MessageFormatter)new XMLModelMessageFormatter());
    }

    public String reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity, Exception exception) throws XNIException {
        String message;
        MessageFormatter messageFormatter = this.getMessageFormatter(domain);
        if (messageFormatter != null) {
            message = messageFormatter.formatMessage(this.fLocale, key, arguments);
        } else {
            int argCount;
            StringBuilder str = new StringBuilder();
            str.append(domain);
            str.append('#');
            str.append(key);
            int n = argCount = arguments != null ? arguments.length : 0;
            if (argCount > 0) {
                str.append('?');
                for (int i = 0; i < argCount; ++i) {
                    str.append(arguments[i]);
                    if (i >= argCount - 1) continue;
                    str.append('&');
                }
            }
            message = str.toString();
        }
        boolean fatalError = severity == 2;
        DiagnosticSeverity diagnosticSeverity = AbstractLSPErrorReporter.toLSPSeverity(severity);
        Range adjustedRange = this.internalToLSPRange(location, key, arguments, message, diagnosticSeverity, fatalError, this.xmlDocument);
        List<DiagnosticRelatedInformation> relatedInformations = null;
        if (adjustedRange == null || NO_RANGE.equals((Object)adjustedRange)) {
            return null;
        }
        if (this.hasRelatedInfo) {
            try {
                relatedInformations = AggregateRelatedInfoFinder.getInstance().findRelatedInformation(this.xmlDocument.offsetAt(adjustedRange.getStart()), key, this.xmlDocument);
            }
            catch (BadLocationException e) {
                LOGGER.severe("Passed bad Range: " + e);
            }
        }
        if (this.addDiagnostic(adjustedRange, message, diagnosticSeverity, key, relatedInformations) == null) {
            return null;
        }
        if (fatalError && !this.fContinueAfterFatalError) {
            XMLParseException parseException = exception != null ? new XMLParseException(location, message, exception) : new XMLParseException(location, message);
            throw parseException;
        }
        return message;
    }

    protected boolean isIgnoreFatalError(String key) {
        return false;
    }

    public Diagnostic addDiagnostic(Range adjustedRange, String message, DiagnosticSeverity severity, String key, List<DiagnosticRelatedInformation> relatedInformation) {
        Diagnostic d = new Diagnostic(adjustedRange, message, severity, this.source, key);
        if (this.hasRelatedInfo && relatedInformation != null && relatedInformation.size() > 0) {
            d.setRelatedInformation(relatedInformation);
        }
        if (this.diagnostics.contains(d)) {
            return null;
        }
        this.diagnostics.add(d);
        return d;
    }

    private static DiagnosticSeverity toLSPSeverity(int severity) {
        switch (severity) {
            case 0: {
                return DiagnosticSeverity.Warning;
            }
        }
        return DiagnosticSeverity.Error;
    }

    private Range internalToLSPRange(XMLLocator location, String key, Object[] arguments, String message, DiagnosticSeverity diagnosticSeverity, boolean fatalError, DOMDocument document) {
        if (location == null) {
            Position start = AbstractLSPErrorReporter.toLSPPosition(0, location, document.getTextDocument());
            Position end = AbstractLSPErrorReporter.toLSPPosition(0, location, document.getTextDocument());
            return new Range(start, end);
        }
        Range range = this.toLSPRange(location, key, arguments, message, diagnosticSeverity, fatalError, document);
        if (range != null) {
            return range;
        }
        return this.createDefaultRange(location, document);
    }

    protected Range createDefaultRange(XMLLocator location, DOMDocument document) {
        int startOffset = location.getCharacterOffset() - 1;
        int endOffset = location.getCharacterOffset() - 1;
        if (startOffset < 0 || endOffset < 0) {
            return null;
        }
        Position start = AbstractLSPErrorReporter.toLSPPosition(startOffset, location, document.getTextDocument());
        Position end = AbstractLSPErrorReporter.toLSPPosition(endOffset, location, document.getTextDocument());
        return new Range(start, end);
    }

    protected abstract Range toLSPRange(XMLLocator var1, String var2, Object[] var3, String var4, DiagnosticSeverity var5, boolean var6, DOMDocument var7);

    private static Position toLSPPosition(int offset, XMLLocator location, TextDocument document) {
        if (location != null && offset == location.getCharacterOffset() - 1) {
            return new Position(location.getLineNumber() - 1, location.getColumnNumber() - 1);
        }
        try {
            return document.positionAt(offset);
        }
        catch (BadLocationException e) {
            return location != null ? new Position(location.getLineNumber() - 1, location.getColumnNumber() - 1) : null;
        }
    }

    protected DOMDocument getDOMDocument() {
        return this.xmlDocument;
    }

    public static boolean initializeReporter(XMLSchemaValidator schemaValidator, XMLErrorReporter reporter) {
        try {
            XMLSchemaLoader schemaLoader = (XMLSchemaLoader)ReflectionUtils.getFieldValue(schemaValidator, "fSchemaLoader");
            return AbstractLSPErrorReporter.initializeReporter(schemaLoader, reporter);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while initializing XML error reporter", e);
            return false;
        }
    }

    public static boolean initializeReporter(XMLSchemaLoader schemaLoader, XMLErrorReporter reporter) {
        try {
            XSDHandler handler = (XSDHandler)ReflectionUtils.getFieldValue(schemaLoader, "fSchemaHandler");
            SchemaDOMParser domParser = (SchemaDOMParser)ReflectionUtils.getFieldValue(handler, "fSchemaParser");
            domParser.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)reporter);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while initializing XML error reporter", e);
            return false;
        }
    }
}

