/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.uriresolver.IExternalGrammarLocationProvider;
import org.eclipse.lemminx.uriresolver.ResolvedURIInfo;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class URIResolverExtensionManager
implements URIResolverExtension,
IExternalGrammarLocationProvider {
    private final List<URIResolverExtension> resolvers = new ArrayList<URIResolverExtension>();
    private final URIResolverExtension defaultURIResolverExtension = new DefaultURIResolverExtension();

    public void registerResolver(URIResolverExtension resolver) {
        this.resolvers.add(resolver);
    }

    public void unregisterResolver(URIResolverExtension resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        for (URIResolverExtension resolver : this.resolvers) {
            String resolved = resolver.resolve(baseLocation, publicId, systemId);
            if (resolved == null || resolved.isEmpty()) continue;
            return resolved;
        }
        return this.defaultURIResolverExtension.resolve(baseLocation, publicId, systemId);
    }

    public ResolvedURIInfo resolveInfo(String baseLocation, String publicId, String systemId) {
        for (URIResolverExtension resolver : this.resolvers) {
            String resolvedURI = resolver.resolve(baseLocation, publicId, systemId);
            if (resolvedURI == null || resolvedURI.isEmpty()) continue;
            return new ResolvedURIInfo(resolvedURI, resolver);
        }
        String resolvedURI = this.defaultURIResolverExtension.resolve(baseLocation, publicId, systemId);
        if (resolvedURI != null && !resolvedURI.isEmpty()) {
            return new ResolvedURIInfo(resolvedURI, this.defaultURIResolverExtension);
        }
        return null;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        XMLInputSource is = null;
        for (URIResolverExtension resolver : this.resolvers) {
            is = resolver.resolveEntity(resourceIdentifier);
            if (is == null) continue;
            return is;
        }
        return this.defaultURIResolverExtension.resolveEntity(resourceIdentifier);
    }

    @Override
    public Map<String, String> getExternalGrammarLocation(URI fileURI) {
        for (URIResolverExtension resolver : this.resolvers) {
            Map<String, String> result;
            if (!(resolver instanceof IExternalGrammarLocationProvider) || (result = ((IExternalGrammarLocationProvider)((Object)resolver)).getExternalGrammarLocation(fileURI)) == null) continue;
            return result;
        }
        return null;
    }

    class DefaultURIResolverExtension
    implements URIResolverExtension {
        DefaultURIResolverExtension() {
        }

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public String resolve(String baseLocation, String publicId, String systemId) {
            try {
                return XMLEntityManager.expandSystemId((String)systemId, (String)baseLocation, (boolean)false);
            }
            catch (URI.MalformedURIException e) {
                return systemId;
            }
        }

        @Override
        public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
            XMLInputSource is = null;
            String id = rid.getPublicId();
            if (id == null) {
                id = rid.getNamespace();
            }
            String location = null;
            if (id != null || rid.getLiteralSystemId() != null) {
                location = this.resolve(rid.getBaseSystemId(), id, rid.getLiteralSystemId());
            }
            if (location != null) {
                is = new XMLInputSource(rid.getPublicId(), location, location);
            }
            return is;
        }
    }
}

