/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.junit.jupiter.api.Test;

public class DTDHighlightingExtensionsTest {
    @Test
    public void noHighlighting() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, note?|)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>";
        XMLAssert.testHighlightsFor(xml, new DocumentHighlight[0]);
    }

    @Test
    public void noHighlighting2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, note?)>\r\n\t<!ATTLIST note version CD|ATA #REQUIRED>\r\n]>";
        XMLAssert.testHighlightsFor(xml, new DocumentHighlight[0]);
    }

    @Test
    public void highlightingOnDTDElementName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT no|te (to,from,heading,body, note?)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(2, 11, 2, 15), DocumentHighlightKind.Write), XMLAssert.hl(XMLAssert.r(2, 39, 2, 43), DocumentHighlightKind.Read), XMLAssert.hl(XMLAssert.r(3, 11, 3, 15), DocumentHighlightKind.Read));
    }

    @Test
    public void highlightingOnDTDAttListName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, note?)>\r\n\t<!ATTLIST no|te version CDATA #REQUIRED>\r\n]>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(3, 11, 3, 15), DocumentHighlightKind.Read), XMLAssert.hl(XMLAssert.r(2, 11, 2, 15), DocumentHighlightKind.Write));
    }

    @Test
    public void highlightingOnDTDElementChildName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, no|te?)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(2, 39, 2, 43), DocumentHighlightKind.Read), XMLAssert.hl(XMLAssert.r(2, 11, 2, 15), DocumentHighlightKind.Write));
    }
}

