/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IncrementalParsingTest {
    String textTemplate = "<a>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n";

    @Test
    public void testBasicChange() {
        String text = "<>\r\n  <b>\r\n  </b>\r\n</a>\r\n";
        String expectedText = "<a>\r\n  <b>\r\n  </b>\r\n</a>\r\n";
        TextDocument document = new TextDocument(text, "uri");
        document.setIncremental(true);
        Range range1 = new Range(new Position(0, 1), new Position(0, 1));
        TextDocumentContentChangeEvent change1 = new TextDocumentContentChangeEvent(range1, Integer.valueOf(0), "a");
        ArrayList<TextDocumentContentChangeEvent> changes = new ArrayList<TextDocumentContentChangeEvent>();
        changes.add(change1);
        document.update(changes);
        Assertions.assertEquals((Object)expectedText, (Object)document.getText());
    }

    @Test
    public void testBasicChangeWord() {
        String text = "<>\r\n  <b>\r\n  </b>\r\n</aaa>\r\n";
        String expectedText = "<aaa>\r\n  <b>\r\n  </b>\r\n</aaa>\r\n";
        TextDocument document = new TextDocument(text, "uri");
        document.setIncremental(true);
        Range range1 = new Range(new Position(0, 1), new Position(0, 1));
        TextDocumentContentChangeEvent change1 = new TextDocumentContentChangeEvent(range1, Integer.valueOf(0), "aaa");
        ArrayList<TextDocumentContentChangeEvent> changes = new ArrayList<TextDocumentContentChangeEvent>();
        changes.add(change1);
        document.update(changes);
        Assertions.assertEquals((Object)expectedText, (Object)document.getText());
    }

    @Test
    public void testChangeReplaceRange() {
        String text = "<zzz>\r\n  <b>\r\n  </b>\r\n</aaa>\r\n";
        String expectedText = "<aaa>\r\n  <b>\r\n  </b>\r\n</aaa>\r\n";
        TextDocument document = new TextDocument(text, "uri");
        document.setIncremental(true);
        Range range1 = new Range(new Position(0, 1), new Position(0, 4));
        TextDocumentContentChangeEvent change1 = new TextDocumentContentChangeEvent(range1, Integer.valueOf(3), "aaa");
        ArrayList<TextDocumentContentChangeEvent> changes = new ArrayList<TextDocumentContentChangeEvent>();
        changes.add(change1);
        document.update(changes);
        Assertions.assertEquals((Object)expectedText, (Object)document.getText());
    }

    @Test
    public void testBasicChangeMultipleChanges() {
        String text = "<>\r\n  <b>\r\n  </>\r\n</a>\r\n";
        String expectedText = "<a>\r\n  <b>\r\n  </b>\r\n</a>\r\n";
        TextDocument document = new TextDocument(text, "uri");
        document.setIncremental(true);
        Range range1 = new Range(new Position(0, 1), new Position(0, 1));
        TextDocumentContentChangeEvent change1 = new TextDocumentContentChangeEvent(range1, Integer.valueOf(0), "a");
        Range range2 = new Range(new Position(2, 4), new Position(2, 4));
        TextDocumentContentChangeEvent change2 = new TextDocumentContentChangeEvent(range2, Integer.valueOf(0), "b");
        ArrayList<TextDocumentContentChangeEvent> changes = new ArrayList<TextDocumentContentChangeEvent>();
        changes.add(change2);
        changes.add(change1);
        document.update(changes);
        Assertions.assertEquals((Object)expectedText, (Object)document.getText());
    }

    @Test
    public void testBasicChangeMultipleChangesReplaceRange() {
        String text = "<zzz>\r\n  <b>\r\n  </eee>\r\n</a>\r\n";
        String expectedText = "<a>\r\n  <b>\r\n  </b>\r\n</a>\r\n";
        TextDocument document = new TextDocument(text, "uri");
        document.setIncremental(true);
        Range range1 = new Range(new Position(0, 1), new Position(0, 4));
        TextDocumentContentChangeEvent change1 = new TextDocumentContentChangeEvent(range1, Integer.valueOf(3), "a");
        Range range2 = new Range(new Position(2, 4), new Position(2, 7));
        TextDocumentContentChangeEvent change2 = new TextDocumentContentChangeEvent(range2, Integer.valueOf(3), "b");
        ArrayList<TextDocumentContentChangeEvent> changes = new ArrayList<TextDocumentContentChangeEvent>();
        changes.add(change2);
        changes.add(change1);
        document.update(changes);
        Assertions.assertEquals((Object)expectedText, (Object)document.getText());
    }

    @Test
    public void testBasicDeletionChange() {
        String text = "<aa>\r\n  <b>\r\n  </b>\r\n</a>\r\n";
        String expectedText = "<a>\r\n  <b>\r\n  </b>\r\n</a>\r\n";
        TextDocument document = new TextDocument(text, "uri");
        document.setIncremental(true);
        Range range1 = new Range(new Position(0, 2), new Position(0, 3));
        TextDocumentContentChangeEvent change1 = new TextDocumentContentChangeEvent(range1, Integer.valueOf(1), "");
        ArrayList<TextDocumentContentChangeEvent> changes = new ArrayList<TextDocumentContentChangeEvent>();
        changes.add(change1);
        document.update(changes);
        Assertions.assertEquals((Object)expectedText, (Object)document.getText());
    }

    @Test
    public void testMultipleDeletionChanges() {
        String text = "<aa>\r\n  <b>\r\n  </bb>\r\n</a>\r\n";
        String expectedText = "<a>\r\n  <b>\r\n  </b>\r\n</a>\r\n";
        TextDocument document = new TextDocument(text, "uri");
        document.setIncremental(true);
        Range range1 = new Range(new Position(0, 2), new Position(0, 3));
        TextDocumentContentChangeEvent change1 = new TextDocumentContentChangeEvent(range1, Integer.valueOf(1), "");
        Range range2 = new Range(new Position(2, 5), new Position(2, 6));
        TextDocumentContentChangeEvent change2 = new TextDocumentContentChangeEvent(range2, Integer.valueOf(1), "");
        ArrayList<TextDocumentContentChangeEvent> changes = new ArrayList<TextDocumentContentChangeEvent>();
        changes.add(change2);
        changes.add(change1);
        document.update(changes);
        Assertions.assertEquals((Object)expectedText, (Object)document.getText());
    }
}

