/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.DocumentLink;
import org.junit.jupiter.api.Test;

public class DTDDocumentLinkTest {
    @Test
    public void docTypeSYSTEM() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"../dtd/entities/base.dtd\" [\r\n\r\n]>\r\n<root-element />";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xml/base.xml", XMLAssert.dl(XMLAssert.r(1, 31, 1, 55), "src/test/resources/dtd/entities/base.dtd"));
    }

    @Test
    public void docTypePUBLIC() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element PUBLIC \"ABCD\" \"../dtd/entities/base.dtd\" [\r\n\r\n]>\r\n<root-element />";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xml/base.xml", XMLAssert.dl(XMLAssert.r(1, 38, 1, 62), "src/test/resources/dtd/entities/base.dtd"));
    }

    @Test
    public void noLinks() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element \"ABCD\" \"../dtd/entities/base.dtd\" [\r\n\r\n]>\r\n<root-element />";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xml/base.xml", new DocumentLink[0]);
    }

    @Test
    public void entity() throws BadLocationException {
        String xml = "<!DOCTYPE chapter PUBLIC \"-//OASIS//DTD DocBook XML V4.4//EN\" \"../docbookx.dtd\" [\r\n\t<!ENTITY % document SYSTEM \"../document.ent\">\r\n\t%document;\r\n\t]> \r\n\t<chapter>\r\n\t</chapter>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xml/base.xml", XMLAssert.dl(XMLAssert.r(0, 63, 0, 78), "src/test/resources/docbookx.dtd"), XMLAssert.dl(XMLAssert.r(1, 29, 1, 44), "src/test/resources/document.ent"));
    }

    @Test
    public void linkWithCatalogAndPublic() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> \r\n<!DOCTYPE web-app\r\n   PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\r\n   \"ABCD.dtd\">\r\n\r\n<web-app></web-app>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xml/base.xml", "src/test/resources/catalogs/catalog-public.xml", XMLAssert.dl(XMLAssert.r(3, 4, 3, 12), "src/test/resources/dtd/web-app_2_3.dtd"));
    }
}

