/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterPreserveAttributeLineBreaksTest {
    @Test
    public void preserveAttributeLineBreaksFormatProlog() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<?xml \nversion=\"1.0\"\nencoding=\"UTF-8\"?>\n<a><b attr=\"value\" attr=\"value\"\n attr\n =\n \"value\"></b>\n</a>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<a>\n  <b attr=\"value\" attr=\"value\"\n    attr=\"value\"></b>\n</a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 1, 0, " "), XMLAssert.te(1, 13, 2, 0, " "), XMLAssert.te(3, 3, 3, 3, "\n  "), XMLAssert.te(3, 31, 4, 1, "\n    "), XMLAssert.te(4, 5, 5, 1, ""), XMLAssert.te(5, 2, 6, 1, ""));
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaks() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a>\n<b attr=\"value\" attr=\"value\"\nattr=\"value\" attr=\"value\"\nattr=\"value\" attr=\"value\">\n</b>\n</a>";
        String expected = "<a>\n  <b attr=\"value\" attr=\"value\"\n    attr=\"value\" attr=\"value\"\n    attr=\"value\" attr=\"value\"> </b>\n</a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, "\n  "), XMLAssert.te(1, 28, 2, 0, "\n    "), XMLAssert.te(2, 25, 3, 0, "\n    "), XMLAssert.te(3, 26, 4, 0, " "));
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaks2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a>\n  <b attr=\"value\" attr=\"value\"\n    attr=\"value\"\n    attr=\"value\"\n    attr=\"value\" attr=\"value\"></b>\n</a\n\n>";
        String expected = "<a>\n  <b attr=\"value\" attr=\"value\"\n    attr=\"value\"\n    attr=\"value\"\n    attr=\"value\" attr=\"value\"></b>\n</a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, XMLAssert.te(5, 3, 7, 0, ""));
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaks3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a\n  attr=\"value\"\n  attr=\"value\"\n\n></a>";
        String expected = "<a\n  attr=\"value\"\n  attr=\"value\"\n></a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, XMLAssert.te(2, 14, 4, 0, "\n"));
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaks4() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a\nattr\n=\n\"value\"\nattr\n=\n\"value\"\n/>";
        String expected = "<a\n  attr=\"value\"\n  attr=\"value\"\n/>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 1, 0, "\n  "), XMLAssert.te(1, 4, 2, 0, ""), XMLAssert.te(2, 1, 3, 0, ""), XMLAssert.te(3, 7, 4, 0, "\n  "), XMLAssert.te(4, 4, 5, 0, ""), XMLAssert.te(5, 1, 6, 0, ""));
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaks5() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a attr=\"value\" attr=\"value\"\n  attr=\n  \"value\" attr=\"value\"></a>";
        String expected = "<a attr=\"value\" attr=\"value\"\n  attr=\"value\" attr=\"value\"></a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, XMLAssert.te(1, 7, 2, 2, ""));
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaksMissingValue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a attr= attr=\"value\"\n  attr=\n   attr=\"value\"></a>";
        String expected = "<a attr= attr=\"value\"\n  attr=\n  attr=\"value\"></a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, XMLAssert.te(1, 7, 2, 3, "\n  "));
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void preserveAttributeLineBreaksCollapseEmptyElement() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<a>\n<b attr=\"value\" attr=\"value\"\nattr=\"value\" attr=\"value\"\nattr=\"value\" attr=\"value\">\n</b>\n</a>";
        String expected = "<a>\n  <b attr=\"value\" attr=\"value\"\n    attr=\"value\" attr=\"value\"\n    attr=\"value\" attr=\"value\" />\n</a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void preserveAttributeLineBreaksCollapseEmptyElement2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<a>\n<b attr=\"value\" attr=\"value\"\nattr=\"value\" attr=\"value\"\nattr=\"value\" attr=\"value\"\n>\n</b>\n</a>";
        String expected = "<a>\n  <b attr=\"value\" attr=\"value\"\n    attr=\"value\" attr=\"value\"\n    attr=\"value\" attr=\"value\"\n  />\n</a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void preserveAttributeLineBreaksCollapseEmptyElement3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<a>\n</a>";
        String expected = "<a />";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaksRangeFormatting() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<a a1=\"123456789\" a2=\"123456789\" a3=\"123456789\"\n  |a4=\"123456789\" a5=\"123456789\" a6=\"123456789|\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\"\n/>";
        String expected = "<a a1=\"123456789\" a2=\"123456789\" a3=\"123456789\"\n  a4=\"123456789\" a5=\"123456789\" a6=\"123456789\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\"\n/>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaksRangeFormattingWithEndTag() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<a a1=\"123456789\" a2=\"123456789\" a3=\"123456789\"\n  |a4=\"123456789\" a5=\"123456789\" a6=\"123456789\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\"\n/>|";
        String expected = "<a a1=\"123456789\" a2=\"123456789\" a3=\"123456789\"\n  a4=\"123456789\" a5=\"123456789\" a6=\"123456789\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\"\n/>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaksRangeFormattingWithEndTag2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        settings.getFormattingSettings().setEmptyElement(XMLFormattingOptions.EmptyElements.collapse);
        String content = "<a a1=\"123456789\" a2=\"123456789\" a3=\"123456789\"\n  |a4=\"123456789\" a5=\"123456789\" a6=\"123456789\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\" />|";
        String expected = "<a a1=\"123456789\" a2=\"123456789\" a3=\"123456789\"\n  a4=\"123456789\" a5=\"123456789\" a6=\"123456789\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\" />";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveAttributeLineBreaksRangeFormattingWithEndTag3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a a1=\"1234|56789\" a2=\"123456789\" a3=\"123456789\"\n  a4=\"123456789\" a5=\"123456789\" a6=\"123456789\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\"\n>|</a>";
        String expected = "<a a1=\"123456789\" a2=\"123456789\" a3=\"123456789\"\n  a4=\"123456789\" a5=\"123456789\" a6=\"123456789\"\n  a7=\"123456789\" a8=\"123456789\" a9=\"123456789\"\n></a>";
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveAttributeLineBreaksTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

