/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterQuoteStyleTest {
    @Disabled
    @Test
    public void testUseDoubleQuotesFromDoubleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        String content = "<a name=  \" value \"> </a>";
        String expected = "<a name=\" value \"></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesFromSingleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  ' value '> </a>";
        String expected = "<a name=' value '></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesFromDoubleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  \" value \"> </a>";
        String expected = "<a name=' value '></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseDoubleQuotesFromSingleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  ' value '> </a>";
        String expected = "<a name=\" value \"></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesNoQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        String content = "<a name = test> </a>";
        String expected = "<a name= test></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesNoQuotesSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setSplitAttributes(true);
        String content = "<a name = test> </a>";
        String expected = "<a" + System.lineSeparator() + "    name=" + System.lineSeparator() + "    test></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testAttValueOnlyStartQuote() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        String content = "<a name = \"> </a>";
        String expected = "<a name=\"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseDoubleQuotesMultipleAttributes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>";
        String expected = "<a name1=\" value1 \" name2=\" value2 \" name3=\" value3 \"></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesMultipleAttributes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>";
        String expected = "<a name1=' value1 ' name2=' value2 ' name3=' value3 '></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseDoubleQuotesMultipleAttributesSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>\n";
        String expected = "<a\n    name1=\" value1 \"\n    name2=\" value2 \"\n    name3=\" value3 \"></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesMultipleAttributesSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>\n";
        String expected = "<a\n    name1=' value1 '\n    name2=' value2 '\n    name3=' value3 '></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesLocalDTD() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!DOCTYPE note SYSTEM \"note.dtd\">";
        String expected = "<!DOCTYPE note SYSTEM 'note.dtd'>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesLocalDTDWithSubset() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!DOCTYPE article [\n  <!ENTITY AUTHOR \"John Doe\">\n  <!ENTITY COMPANY \"JD Power Tools, Inc.\">\n  <!ENTITY EMAIL \"jd@jd-tools.com\">\n  <!ELEMENT E EMPTY>\n  <!ATTLIST E WIDTH CDATA \"0\">\n]>\n\n<root attr=\"hello\"></root>";
        String expected = "<!DOCTYPE article [\n  <!ENTITY AUTHOR 'John Doe'>\n  <!ENTITY COMPANY 'JD Power Tools, Inc.'>\n  <!ENTITY EMAIL 'jd@jd-tools.com'>\n  <!ELEMENT E EMPTY>\n  <!ATTLIST E WIDTH CDATA '0'>\n]>\n\n<root attr='hello'></root>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUseSingleQuotesDTDFile() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!ENTITY AUTHOR \"John Doe\">\n<!ENTITY COMPANY \"JD Power Tools, Inc.\">\n<!ENTITY EMAIL \"jd@jd-tools.com\">\n<!ELEMENT E EMPTY>\n<!ATTLIST E WIDTH CDATA \"0\">";
        String expected = "<!ENTITY AUTHOR 'John Doe'>\n<!ENTITY COMPANY 'JD Power Tools, Inc.'>\n<!ENTITY EMAIL 'jd@jd-tools.com'>\n<!ELEMENT E EMPTY>\n<!ATTLIST E WIDTH CDATA '0'>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, "test.dtd", new TextEdit[0]);
    }

    @Test
    public void testDontFormatQuotesByDefault() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        String expected = content = "<a number='\"one\"'></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testAttributeNameTouchingPreviousValue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setSplitAttributes(true);
        String content = "<xml>\r\n  <a zz= tt = \"aa\"aa ></a>\r\n</xml>";
        String expected = "<xml>\r\n  <a\r\n      zz=\r\n      tt='aa'\r\n      aa></a>\r\n</xml>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void enforceSingleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a  attr   =     \"value\" />";
        String expected = "<a attr='value' />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void enforceDoubleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a  attr   =     'value' />";
        String expected = "<a attr=\"value\" />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void enforceSingleQuoteStyleProlog() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String expected = "<?xml version='1.0' encoding='UTF-8'?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void enforceDoubleQuoteStyleProlog() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<?xml version='1.0' encoding='UTF-8'?>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void dontEnforceSingleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String content = "<a attr  =   \"'\" attr2   =     '\"' />";
        String expected = "<a attr=\"'\" attr2='\"' />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void dontEnforceSingleQuoteStyleProlog() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void dontEnforceDoubleQuoteStyleProlog() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String expected = content = "<?xml version='1.0' encoding='UTF-8'?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void dontEnforceDoubleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String content = "<a attr  =   \"'\" attr2   =     '\"' />";
        String expected = "<a attr=\"'\" attr2='\"' />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterQuoteStyleTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterQuoteStyleTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

