/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterSetSpaceBeforeEmptyCloseTagTest {
    @Disabled
    @Test
    public void testSelfCloseTagSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(true);
        String content = "<a>\r <b/>\r</a>";
        String expected = "<a>\r  <b />\r</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagAlreadyHasSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(true);
        String content = "<a>\r <b />\r</a>";
        String expected = "<a>\r  <b />\r</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagSpaceFalse() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r <b/>\r</a>";
        String expected = "<a>\r  <b/>\r</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testSelfCloseTagSpaceFalseAlreadyHasSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r <b />\r</a>";
        String expected = "<a>\r  <b/>\r</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontAddClosingBracket() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r <b\r</a>";
        String expected = "<a>\r  <b\r</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testEndTagMissingCloseBracket() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r <b> Value </b\r</a>";
        String expected = "<a>\r  <b> Value </b\r</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

