/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSLoaderImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.FilesChangedTracker;
import org.eclipse.lemminx.extensions.xerces.ReflectionUtils;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDAttributeDeclaration;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDElementDeclaration;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.URIUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMXSDDocument
implements CMDocument,
XSElementDeclHelper {
    private static final Logger LOGGER = Logger.getLogger(CMXSDDocument.class.getName());
    private final XSModel model;
    private final Map<XSElementDeclaration, CMXSDElementDeclaration> elementMappings;
    private Collection<CMElementDeclaration> elements;
    private final FilesChangedTracker tracker;
    private final XSLoaderImpl xsLoader;

    public CMXSDDocument(XSModel model, XSLoaderImpl xsLoaderImpl) {
        this.model = model;
        this.xsLoader = xsLoaderImpl;
        this.elementMappings = new HashMap<XSElementDeclaration, CMXSDElementDeclaration>();
        this.tracker = CMXSDDocument.createFilesChangedTracker(model);
    }

    private static FilesChangedTracker createFilesChangedTracker(XSModel model) {
        HashSet<SchemaGrammar> grammars = new HashSet<SchemaGrammar>();
        XSNamespaceItemList namespaces = model.getNamespaceItems();
        for (int i = 0; i < namespaces.getLength(); ++i) {
            SchemaGrammar grammar = CMXSDDocument.getSchemaGrammar(namespaces.item(i));
            if (grammar == null) continue;
            grammars.add(grammar);
        }
        return XSDUtils.createFilesChangedTracker(grammars);
    }

    @Override
    public boolean hasNamespace(String namespaceURI) {
        if (namespaceURI == null || this.model.getNamespaces() == null) {
            return false;
        }
        return this.model.getNamespaces().contains(namespaceURI);
    }

    @Override
    public Collection<CMElementDeclaration> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<CMElementDeclaration>();
            XSNamedMap map = this.model.getComponents((short)2);
            for (int j = 0; j < map.getLength(); ++j) {
                XSElementDeclaration elementDeclaration = (XSElementDeclaration)map.item(j);
                this.collectElement(elementDeclaration, this.elements);
            }
        }
        return this.elements;
    }

    void collectElement(XSElementDeclaration elementDeclaration, Collection<CMElementDeclaration> elements) {
        if (elementDeclaration.getAbstract()) {
            XSObjectList list = this.getSubstitutionGroup(elementDeclaration);
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    XSObject object = list.item(i);
                    if (object.getType() != 2) continue;
                    XSElementDeclaration subElementDeclaration = (XSElementDeclaration)object;
                    this.collectElement(subElementDeclaration, elements);
                }
            }
        } else {
            CMElementDeclaration cmElement = this.getXSDElement(elementDeclaration);
            if (!elements.contains(cmElement)) {
                elements.add(cmElement);
            }
        }
    }

    XSObjectList getSubstitutionGroup(XSElementDeclaration elementDeclaration) {
        return this.model.getSubstitutionGroup(elementDeclaration);
    }

    @Override
    public CMElementDeclaration findCMElement(DOMElement element, String namespace) {
        ArrayList<DOMElement> paths = new ArrayList<DOMElement>();
        while (element != null && (namespace == null || namespace.equals(element.getNamespaceURI()))) {
            paths.add(0, element);
            element = element.getParentNode() instanceof DOMElement ? (DOMElement)element.getParentNode() : null;
        }
        CMElementDeclaration declaration = null;
        for (int i = 0; i < paths.size(); ++i) {
            DOMElement elt = (DOMElement)paths.get(i);
            declaration = i == 0 ? this.findElementDeclaration(elt.getLocalName(), namespace) : declaration.findCMElement(elt.getLocalName(), namespace);
            if (declaration == null) break;
        }
        return declaration;
    }

    private CMElementDeclaration findElementDeclaration(String tag, String namespace) {
        for (CMElementDeclaration cmElement : this.getElements()) {
            if (!cmElement.getName().equals(tag)) continue;
            return cmElement;
        }
        return null;
    }

    CMElementDeclaration getXSDElement(XSElementDeclaration elementDeclaration) {
        CMXSDElementDeclaration element = this.elementMappings.get(elementDeclaration);
        if (element == null) {
            element = new CMXSDElementDeclaration(this, elementDeclaration);
            this.elementMappings.put(elementDeclaration, element);
        }
        return element;
    }

    static Collection<String> getEnumerationValues(XSSimpleTypeDefinition typeDefinition) {
        if (typeDefinition != null) {
            if (CMXSDDocument.isBooleanType(typeDefinition)) {
                return StringUtils.TRUE_FALSE_ARRAY;
            }
            StringList enumerations = typeDefinition.getLexicalEnumeration();
            if (enumerations != null && !enumerations.isEmpty()) {
                return enumerations;
            }
            XSObjectList memberTypes = typeDefinition.getMemberTypes();
            if (memberTypes != null && !memberTypes.isEmpty()) {
                ArrayList<String> enumerationValues = new ArrayList<String>();
                for (Object memberType : memberTypes) {
                    if (!(memberType instanceof XSSimpleTypeDefinition)) continue;
                    enumerationValues.addAll(CMXSDDocument.getEnumerationValues((XSSimpleTypeDefinition)memberType));
                }
                return enumerationValues;
            }
        }
        return Collections.emptyList();
    }

    static boolean isBooleanType(XSSimpleTypeDefinition typeDefinition) {
        if (typeDefinition instanceof XSSimpleType) {
            return ((XSSimpleType)typeDefinition).getPrimitiveKind() == 2;
        }
        return false;
    }

    static XSObjectList getEnumerationAnnotations(XSSimpleTypeDefinition simpleTypeDefinition, String value) {
        if (simpleTypeDefinition instanceof XSSimpleTypeDecl) {
            XSSimpleTypeDecl simpleTypeDecl = (XSSimpleTypeDecl)simpleTypeDefinition;
            XSObjectList multiFacets = simpleTypeDecl.getMultiValueFacets();
            if (!multiFacets.isEmpty()) {
                XSMultiValueFacet facet = (XSMultiValueFacet)multiFacets.get(0);
                Object[] annotationArray = (multiFacets = facet.getAnnotations()).toArray();
                if (!CMXSDDocument.onlyContainsNull(annotationArray)) {
                    return simpleTypeDecl.getMultiValueFacets();
                }
            } else {
                XSObjectList memberTypes = simpleTypeDecl.getMemberTypes();
                if (memberTypes != null) {
                    for (Object memberType : memberTypes) {
                        StringList values;
                        if (!(memberType instanceof XSSimpleTypeDecl)) continue;
                        XSSimpleTypeDecl type = (XSSimpleTypeDecl)memberType;
                        XSObjectList enumerationAnnotations = type.enumerationAnnotations;
                        if (enumerationAnnotations == null || (values = type.getLexicalEnumeration()) == null) continue;
                        int enumIndex = -1;
                        for (int i = 0; i < values.getLength(); ++i) {
                            String enumValue = values.item(i);
                            if (!value.equals(enumValue)) continue;
                            enumIndex = i;
                            break;
                        }
                        if (enumIndex == -1 || enumerationAnnotations.size() <= enumIndex) continue;
                        XSAnnotation annotation = (XSAnnotation)enumerationAnnotations.get(enumIndex);
                        if (annotation == null) {
                            return null;
                        }
                        return new XSObjectListImpl((XSObject[])new XSAnnotation[]{annotation}, 1);
                    }
                }
            }
        }
        return null;
    }

    private static boolean onlyContainsNull(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        for (Object o : arr) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public XSElementDecl getGlobalElementDecl(QName element) {
        return (XSElementDecl)this.model.getElementDeclaration(element.localpart, element.uri);
    }

    @Override
    public LocationLink findTypeLocation(DOMNode originNode) {
        String documentURI;
        DOMElement originElement = null;
        DOMAttr originAttribute = null;
        if (originNode.isElement()) {
            originElement = (DOMElement)originNode;
        } else if (originNode.isAttribute()) {
            originAttribute = (DOMAttr)originNode;
            originElement = originAttribute.getOwnerElement();
        }
        if (originElement == null || originElement.getLocalName() == null) {
            return null;
        }
        CMXSDElementDeclaration elementDeclaration = (CMXSDElementDeclaration)this.findCMElement(originElement, originElement.getNamespaceURI());
        if (elementDeclaration == null) {
            return null;
        }
        ElementImpl xercesElement = CMXSDDocument.findLocalMappedXercesElement(elementDeclaration.getElementDeclaration(), this.xsLoader);
        SchemaGrammar schemaGrammar = this.getOwnerSchemaGrammar(elementDeclaration.getElementDeclaration());
        if (schemaGrammar == null && xercesElement == null) {
            return null;
        }
        String string = documentURI = xercesElement != null ? xercesElement.getOwnerDocument().getDocumentURI() : CMXSDDocument.getSchemaURI(schemaGrammar);
        if (URIUtils.isFileResource(documentURI)) {
            DOMDocument targetSchema = DOMUtils.loadDocument(documentURI, originNode.getOwnerDocument().getResolverExtensionManager());
            if (targetSchema == null) {
                return null;
            }
            if (originAttribute != null) {
                XSAttributeDeclaration attributeDecl;
                String attributeName = originAttribute.getName();
                CMXSDAttributeDeclaration attributeDeclaration = (CMXSDAttributeDeclaration)elementDeclaration.findCMAttribute(attributeName);
                if (attributeDeclaration != null && (attributeDecl = attributeDeclaration.getAttrDeclaration()).getScope() == 2) {
                    return CMXSDDocument.findLocalXSAttribute(originAttribute, targetSchema, attributeDecl.getEnclosingCTDefinition(), schemaGrammar);
                }
            } else {
                boolean globalElement;
                boolean bl = globalElement = elementDeclaration.getElementDeclaration().getScope() == 1;
                if (globalElement) {
                    return CMXSDDocument.findGlobalXSElement(originElement, targetSchema);
                }
                if (xercesElement != null) {
                    return CMXSDDocument.findLocalXSElement(originElement, targetSchema, xercesElement.getCharacterOffset());
                }
                XSComplexTypeDefinition complexTypeDefinition = elementDeclaration.getElementDeclaration().getEnclosingCTDefinition();
                if (complexTypeDefinition != null) {
                    return CMXSDDocument.findLocalXSElement(originElement, targetSchema, complexTypeDefinition, schemaGrammar);
                }
            }
        }
        return null;
    }

    static String getSchemaURI(SchemaGrammar schemaGrammar) {
        if (schemaGrammar == null) {
            return null;
        }
        return schemaGrammar.getDocumentLocations().item(0);
    }

    SchemaGrammar getOwnerSchemaGrammar(XSElementDeclaration elementDeclaration) {
        XSNamespaceItem namespace;
        int i;
        XSNamespaceItem namespaceItem;
        SchemaGrammar grammar;
        XSComplexTypeDefinition enclosingType = elementDeclaration.getEnclosingCTDefinition();
        if (enclosingType == null && elementDeclaration.getScope() == 0) {
            enclosingType = elementDeclaration.getTypeDefinition();
        }
        if ((grammar = CMXSDDocument.getSchemaGrammar(namespaceItem = enclosingType != null ? enclosingType.getNamespaceItem() : elementDeclaration.getNamespaceItem())) != null) {
            return grammar;
        }
        XSNamespaceItemList namespaces = this.model.getNamespaceItems();
        if (elementDeclaration.getScope() == 1) {
            for (i = 0; i < namespaces.getLength(); ++i) {
                namespace = namespaces.item(i);
                if (!(namespace instanceof SchemaGrammar) || !elementDeclaration.equals(((SchemaGrammar)namespace).getElementDeclaration(elementDeclaration.getName()))) continue;
                return (SchemaGrammar)namespace;
            }
        }
        if (enclosingType == null) {
            return null;
        }
        for (i = 0; i < namespaces.getLength(); ++i) {
            XSComplexTypeDecl[] complexTypes;
            namespace = namespaces.item(i);
            if (!(namespace instanceof SchemaGrammar) || (complexTypes = CMXSDDocument.getXSComplexTypeDecls((SchemaGrammar)namespace)) == null) continue;
            for (int j = 0; j < complexTypes.length; ++j) {
                if (!enclosingType.equals(complexTypes[j])) continue;
                return (SchemaGrammar)namespace;
            }
        }
        return null;
    }

    private static SchemaGrammar getSchemaGrammar(XSNamespaceItem namespaceItem) {
        return namespaceItem != null && namespaceItem instanceof SchemaGrammar ? (SchemaGrammar)namespaceItem : null;
    }

    private static LocationLink findGlobalXSElement(DOMElement originElement, DOMDocument targetSchema) {
        NodeList children = targetSchema.getDocumentElement().getChildNodes();
        return CMXSDDocument.findXSElement(originElement, children, false);
    }

    private static ElementImpl findLocalMappedXercesElement(XSElementDeclaration elementDeclaration, XSLoaderImpl xsLoader) {
        try {
            XMLSchemaLoader schemaLoader = (XMLSchemaLoader)ReflectionUtils.getFieldValue(xsLoader, "fSchemaLoader");
            XSDHandler handler = (XSDHandler)ReflectionUtils.getFieldValue(schemaLoader, "fSchemaHandler");
            XSParticleDecl[] fParticle = (XSParticleDecl[])ReflectionUtils.getFieldValue(handler, "fParticle");
            int i = CMXSDDocument.getXSElementDeclIndex(elementDeclaration, fParticle);
            if (i >= 0) {
                Element[] fLocalElementDecl = (Element[])ReflectionUtils.getFieldValue(handler, "fLocalElementDecl");
                return (ElementImpl)fLocalElementDecl[i];
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while retrieving mapped Xerces xs:element of '" + elementDeclaration.getName() + "'.", e);
        }
        return null;
    }

    private static LocationLink findLocalXSElement(DOMElement originElement, DOMDocument targetSchema, int offset) {
        DOMNode node = targetSchema.findNodeAt(offset);
        if (node != null && node.isElement()) {
            return CMXSDDocument.findXSElement(originElement, (Element)((Object)node));
        }
        return null;
    }

    private static int getXSElementDeclIndex(XSElementDeclaration elementDeclaration, XSParticleDecl[] particles) {
        for (int i = 0; i < particles.length; ++i) {
            XSParticleDecl particle = particles[i];
            if (particle == null || !elementDeclaration.equals(particle.fValue)) continue;
            return i;
        }
        return -1;
    }

    private static LocationLink findLocalXSElement(DOMElement originElement, DOMDocument targetSchema, XSComplexTypeDefinition enclosingType, SchemaGrammar schemaGrammar) {
        DOMNode node;
        int complexTypeOffset = CMXSDDocument.getComplexTypeOffset(enclosingType, schemaGrammar);
        if (complexTypeOffset != -1 && (node = targetSchema.findNodeAt(complexTypeOffset)) != null && node.isElement() && node.hasChildNodes()) {
            return CMXSDDocument.findXSElement(originElement, node.getChildNodes(), true);
        }
        return null;
    }

    private static int getComplexTypeOffset(XSComplexTypeDefinition complexType, SchemaGrammar grammar) {
        try {
            SimpleLocator[] fCTLocators = (SimpleLocator[])ReflectionUtils.getFieldValue(grammar, "fCTLocators");
            XSComplexTypeDecl[] fComplexTypeDecls = CMXSDDocument.getXSComplexTypeDecls(grammar);
            for (int i = 0; i < fComplexTypeDecls.length; ++i) {
                if (!complexType.equals(fComplexTypeDecls[i])) continue;
                SimpleLocator locator = fCTLocators[i];
                return locator != null ? locator.getCharacterOffset() : -1;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while retrieving offset of local xs:complexType'" + complexType.getName() + "'.", e);
        }
        return -1;
    }

    private static XSComplexTypeDecl[] getXSComplexTypeDecls(SchemaGrammar grammar) {
        try {
            return (XSComplexTypeDecl[])ReflectionUtils.getFieldValue(grammar, "fComplexTypeDecls");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while retrieving list of xs:complexType of the grammar '" + grammar.getSchemaNamespace() + "'.", e);
            return null;
        }
    }

    private static LocationLink findXSElement(DOMElement originElement, NodeList children, boolean inAnyLevel) {
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            Element elt = (Element)n;
            LocationLink location = CMXSDDocument.findXSElement(originElement, elt);
            if (location != null) {
                return location;
            }
            if (!inAnyLevel || !elt.hasChildNodes() || (location = CMXSDDocument.findXSElement(originElement, elt.getChildNodes(), inAnyLevel)) == null) continue;
            return location;
        }
        return null;
    }

    private static LocationLink findXSElement(DOMElement originElement, Element elt) {
        if (XSDUtils.isXSElement(elt) && originElement.getLocalName().equals(elt.getAttribute("name"))) {
            DOMAttr targetAttr = (DOMAttr)elt.getAttributeNode("name");
            LocationLink location = XMLPositionUtility.createLocationLink(originElement, targetAttr.getNodeAttrValue());
            return location;
        }
        return null;
    }

    private static LocationLink findLocalXSAttribute(DOMAttr originAttribute, DOMDocument targetSchema, XSComplexTypeDefinition enclosingType, SchemaGrammar schemaGrammar) {
        DOMNode node;
        int complexTypeOffset = CMXSDDocument.getComplexTypeOffset(enclosingType, schemaGrammar);
        if (complexTypeOffset != -1 && (node = targetSchema.findNodeAt(complexTypeOffset)) != null && node.isElement() && node.hasChildNodes()) {
            return CMXSDDocument.findXSAttribute(originAttribute, node.getChildNodes(), true);
        }
        return null;
    }

    private static LocationLink findXSAttribute(DOMAttr originAttribute, NodeList children, boolean inAnyLevel) {
        for (int i = 0; i < children.getLength(); ++i) {
            LocationLink location;
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            DOMElement elt = (DOMElement)n;
            if (XSDUtils.isXSAttribute(elt) && originAttribute.getName().equals(elt.getAttribute("name"))) {
                DOMAttr targetAttr = elt.getAttributeNode("name");
                LocationLink location2 = XMLPositionUtility.createLocationLink(originAttribute.getNodeAttrName(), targetAttr.getNodeAttrValue());
                return location2;
            }
            if (!inAnyLevel || !elt.hasChildNodes() || (location = CMXSDDocument.findXSAttribute(originAttribute, elt.getChildNodes(), inAnyLevel)) == null) continue;
            return location;
        }
        return null;
    }

    @Override
    public boolean isDirty() {
        return this.tracker.isDirty();
    }
}

