/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons.snippets;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.lemminx.commons.snippets.Snippet;
import org.eclipse.lemminx.commons.snippets.SnippetRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnippetRegistryTest {
    @Test
    public void withoutLabel() throws IOException {
        String json = "{\r\n  \"Insert CDATA\": {\r\n    \"prefix\": [\r\n      \"<![CDATA[\"\r\n    ],\r\n    \"description\": \"Insert CDATA\"\r\n  }\r\n }";
        SnippetRegistry registry = new SnippetRegistry(null, false);
        registry.registerSnippets((Reader)new StringReader(json));
        Assertions.assertEquals((int)1, (int)registry.getSnippets().size());
        Assertions.assertEquals((Object)"<![CDATA[", (Object)((Snippet)registry.getSnippets().get(0)).getLabel());
    }

    @Test
    public void staticLabel() throws IOException {
        String json = "{\r\n  \"Insert CDATA\": {\r\n    \"prefix\": [\r\n      \"<![CDATA[\"\r\n    ],\r\n    \"label\": \"Static label\",\r\n    \"description\": \"Insert CDATA\"\r\n  }\r\n }";
        SnippetRegistry registry = new SnippetRegistry(null, false);
        registry.registerSnippets((Reader)new StringReader(json));
        Assertions.assertEquals((int)1, (int)registry.getSnippets().size());
        Assertions.assertEquals((Object)"Static label", (Object)((Snippet)registry.getSnippets().get(0)).getLabel());
    }

    @Test
    public void withDynamicLabel() throws IOException {
        String json = "{\r\n  \"Insert CDATA\": {\r\n    \"prefix\": [\r\n      \"<![CDATA[\"\r\n    ],\r\n    \"label\": \"$description - $prefix\",\r\n    \"description\": \"Insert CDATA\"\r\n  }\r\n }";
        SnippetRegistry registry = new SnippetRegistry(null, false);
        registry.registerSnippets((Reader)new StringReader(json));
        Assertions.assertEquals((int)1, (int)registry.getSnippets().size());
        Assertions.assertEquals((Object)"Insert CDATA - <![CDATA[", (Object)((Snippet)registry.getSnippets().get(0)).getLabel());
    }

    @Test
    public void withDynamicLabelAndWithoutDescription() throws IOException {
        String json = "{\r\n  \"Insert CDATA\": {\r\n    \"prefix\": [\r\n      \"<![CDATA[\"\r\n    ],\r\n    \"label\": \"$description - $prefix\"\r\n  }\r\n }";
        SnippetRegistry registry = new SnippetRegistry(null, false);
        registry.registerSnippets((Reader)new StringReader(json));
        Assertions.assertEquals((int)1, (int)registry.getSnippets().size());
        Assertions.assertEquals((Object)"$description - <![CDATA[", (Object)((Snippet)registry.getSnippets().get(0)).getLabel());
    }
}

