/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLParser {
    private Map<Integer, HashMap<String, String>> keyValues;
    private List<Integer> idList;
    private int id = 0;
    private int currentlyIn = 0;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TEXT = "text";
    private static final String noName = "NoName";
    private boolean textMode;

    XMLParser() {
        if (this.keyValues != null) {
            this.keyValues.clear();
        }
        this.keyValues = new HashMap<Integer, HashMap<String, String>>();
        if (this.idList != null) {
            this.idList.clear();
        }
        this.idList = new ArrayList<Integer>();
        this.textMode = false;
    }

    public void parse(File file) {
        this.parse(XMLParser.getContents(file));
    }

    public void parse(String message) {
        String[] lines;
        String tabstrip = message.replaceAll("\t", "");
        for (String line : lines = tabstrip.split("\n")) {
            String[] tokens;
            if (line.length() < 1) continue;
            if (line.charAt(0) == '<') {
                HashMap<String, String> map;
                if (line.charAt(1) == '/') {
                    this.idList.remove((Object)this.currentlyIn);
                    this.currentlyIn = -1;
                    if (this.idList.size() > 0) {
                        this.currentlyIn = this.idList.get(this.idList.size() - 1);
                    }
                    this.setTextMode(true);
                    continue;
                }
                if (line.substring(line.length() - 2, line.length() - 1).equals("/>")) {
                    ++this.id;
                    tokens = line.split(" ");
                    map = new HashMap<String, String>();
                    map.put(ATTR_NAME, tokens[0]);
                    this.keyValues.put(this.id, map);
                    this.textMode = false;
                    this.addAttributes(this.currentlyIn, tokens, 1);
                    continue;
                }
                this.idList.add(this.id);
                this.currentlyIn = ++this.id;
                tokens = line.split(" ");
                map = new HashMap();
                map.put(ATTR_NAME, tokens[0]);
                this.keyValues.put(this.id, map);
                this.addAttributes(this.currentlyIn, tokens, 1);
                continue;
            }
            if (this.currentlyIn < 0) continue;
            if (this.textMode) {
                HashMap<String, String> map = this.keyValues.get(this.currentlyIn);
                map.put(ATTR_TEXT, line);
            }
            tokens = line.split(" ");
            this.addAttributes(this.currentlyIn, tokens, 0);
        }
    }

    private void addAttributes(int id, String[] tokens, int start) {
        HashMap<String, String> map = this.keyValues.get(id);
        int nameless = 0;
        for (int j = start; j < tokens.length; ++j) {
            String[] kvPair = tokens[j].split("=");
            String value = "";
            String key = "";
            if (kvPair.length < 1) continue;
            if (kvPair.length < 2) {
                value = kvPair[0];
                if (value.charAt(value.length() - 1) == '>') {
                    this.setTextMode(true);
                    value = value.substring(0, value.length() - 1);
                }
                map.put(noName + nameless, value);
                ++nameless;
                continue;
            }
            value = kvPair[0];
            key = kvPair[1];
            if (value.charAt(value.length() - 1) == '>') {
                this.setTextMode(true);
                value = value.substring(0, value.length() - 1);
            }
            map.put(key, value);
        }
        this.keyValues.put(id, map);
    }

    private static String getContents(File file) {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append("\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    private void setTextMode(boolean val) {
        this.textMode = val;
    }
}

