/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.guava.deser.util.RangeHelper;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.io.IOException;

public class RangeKeyDeserializer
extends KeyDeserializer
implements ContextualKeyDeserializer {
    protected final JavaType _rangeType;
    protected final KeyDeserializer _fromStringDeserializer;

    public RangeKeyDeserializer(JavaType type) {
        this(type, null);
    }

    protected RangeKeyDeserializer(JavaType rangeType, KeyDeserializer rangeDeserializer) {
        this._rangeType = rangeType;
        this._fromStringDeserializer = rangeDeserializer;
    }

    public KeyDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType endpointType = this._rangeType.containedType(0);
        if (endpointType == null) {
            endpointType = TypeFactory.unknownType();
        }
        KeyDeserializer kd = this._fromStringDeserializer;
        kd = ctxt.findKeyDeserializer(endpointType, property);
        if (kd != this._fromStringDeserializer) {
            return new RangeKeyDeserializer(this._rangeType, kd);
        }
        return this;
    }

    public Object deserializeKey(String rangeInterval, DeserializationContext context) throws IOException {
        if (rangeInterval.isEmpty()) {
            throw context.instantiationException(RangeMap.class, "RangeMap keys can't be null or empty.");
        }
        return RangeHelper.getRangeFromString(rangeInterval, context, this._fromStringDeserializer, this._rangeType, Range.class);
    }
}

