/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.automaton;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.automaton.MPAState;
import org.eclipse.lsat.common.ludus.backend.automaton.MPATransition;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.graph.DoubleWeightedGraph;
import org.eclipse.lsat.common.ludus.backend.graph.SingleWeightedGraph;

public class MaxPlusAutomaton<T>
implements SingleWeightedGraph<MPAState<T>, MPATransition<T>, Value>,
DoubleWeightedGraph<MPAState<T>, MPATransition<T>, Value> {
    private static final long serialVersionUID = 1L;
    private final Set<MPAState<T>> states = new HashSet<MPAState<T>>();
    private final Set<MPATransition<T>> mpaTransitions = new HashSet<MPATransition<T>>();
    private final Map<MPAState<T>, Set<MPATransition<T>>> outgoingMap = new HashMap<MPAState<T>, Set<MPATransition<T>>>();
    private final Map<MPAState<T>, Set<MPATransition<T>>> incomingMap = new HashMap<MPAState<T>, Set<MPATransition<T>>>();
    private final Map<Tuple<T, Integer>, MPAState<T>> stateMap = new HashMap<Tuple<T, Integer>, MPAState<T>>();

    public void addState(MPAState<T> MPAState2) {
        this.states.add(MPAState2);
        this.stateMap.put(Tuple.of(MPAState2.getLocation(), MPAState2.getIndex()), MPAState2);
    }

    public void addTransition(MPATransition<T> MPATransition2) {
        MPAState<T> src = MPATransition2.getSource();
        MPAState<T> tgt = MPATransition2.getTarget();
        this.outgoingMap.putIfAbsent(src, new HashSet());
        Set<MPATransition<T>> out = this.outgoingMap.get(src);
        out.add(MPATransition2);
        this.incomingMap.putIfAbsent(tgt, new HashSet());
        Set<MPATransition<T>> in = this.incomingMap.get(tgt);
        in.add(MPATransition2);
        this.mpaTransitions.add(MPATransition2);
    }

    @Override
    public Value getWeight1(MPATransition<T> edge) {
        return edge.getReward();
    }

    @Override
    public Value getWeight2(MPATransition<T> edge) {
        return edge.getDuration();
    }

    @Override
    public Value getWeight(MPATransition<T> edge) {
        return edge.getDuration();
    }

    public MPAState<T> getState(T fsmState, Integer index) {
        return this.stateMap.get(Tuple.of(fsmState, index));
    }

    @Override
    public Set<MPAState<T>> getVertices() {
        return this.states;
    }

    @Override
    public Set<MPATransition<T>> getEdges() {
        return this.mpaTransitions;
    }

    @Override
    public Collection<MPATransition<T>> incomingEdgesOf(MPAState<T> MPAState2) {
        return this.incomingMap.getOrDefault(MPAState2, Collections.emptySet());
    }

    @Override
    public Collection<MPATransition<T>> outgoingEdgesOf(MPAState<T> MPAState2) {
        return this.outgoingMap.getOrDefault(MPAState2, Collections.emptySet());
    }

    @Override
    public MPAState<T> getEdgeSource(MPATransition<T> MPATransition2) {
        return MPATransition2.getSource();
    }

    @Override
    public MPAState<T> getEdgeTarget(MPATransition<T> MPATransition2) {
        return MPATransition2.getTarget();
    }

    @Override
    public MPATransition<T> getEdge(MPAState<T> source, MPAState<T> target) {
        for (MPATransition<T> t : this.outgoingEdgesOf(source)) {
            if (!t.getTarget().equals(target)) continue;
            return t;
        }
        return null;
    }
}

