/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.fsm;

import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;

public class PrintToCIF {
    private PrintToCIF() {
    }

    public static String print(FSM<Location, Edge> fsm, String name) {
        StringBuilder sb = new StringBuilder();
        for (String cEvent : fsm.getControllable()) {
            sb.append("controllable ");
            sb.append(cEvent);
            sb.append(";\n");
        }
        for (String uEvent : fsm.getUncontrollable()) {
            sb.append("uncontrollable ");
            sb.append(uEvent);
            sb.append(";\n");
        }
        sb.append("\nplant automaton ");
        name = name.replaceAll("-", "_");
        sb.append(name);
        sb.append(":\n");
        for (Location l : fsm.getVertices()) {
            sb.append("  location ");
            sb.append(l.getName());
            if (fsm.outgoingEdgesOf(l).isEmpty() && !l.equals(fsm.getInitial()) && !fsm.isMarked(l)) {
                sb.append(";\n");
            } else {
                sb.append(":\n");
            }
            if (l.equals(fsm.getInitial())) {
                sb.append("    initial;\n");
            }
            if (fsm.isMarked(l)) {
                sb.append("    marked;\n");
            }
            for (Edge e : fsm.outgoingEdgesOf(l)) {
                sb.append("    edge ");
                sb.append(e.getEvent());
                sb.append(" goto ");
                sb.append(e.getTarget().getName());
                sb.append(";\n");
            }
        }
        sb.append("end");
        return sb.toString();
    }
}

