/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.policy;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Triple;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.policy.MeanPayoffGamePolicyIteration;

public class PolicyIterationInt {
    private static final Fraction MINUS_INFINITY = new Fraction(Integer.MIN_VALUE);

    private PolicyIterationInt() {
    }

    public static <V, E> Tuple<Map<V, Fraction>, StrategyVector<V, E>> solve(MeanPayoffGamePolicyIteration<V, E, Integer> game) {
        Set vertices = game.getVertices();
        boolean improvement = true;
        Map distVector = PolicyIterationInt.initializeVector(vertices, Fraction.ZERO);
        Map meanPayoffVector = PolicyIterationInt.initializeVector(vertices, MINUS_INFINITY);
        StrategyVector currentStrategy = new StrategyVector();
        currentStrategy.initializeRandomStrategy(game);
        while (improvement) {
            Triple<Map<V, Fraction>, Map<V, Fraction>, StrategyVector<V, E>> result = PolicyIterationInt.improveStrategyPlayer1(game, currentStrategy, distVector, meanPayoffVector);
            distVector = result.getLeft();
            meanPayoffVector = result.getMiddle();
            currentStrategy = result.getRight();
            improvement = false;
            for (Object v : game.getV0()) {
                for (Object e : game.outgoingEdgesOf(v)) {
                    Object u = game.getEdgeTarget(e);
                    Fraction mw = meanPayoffVector.get(u);
                    Integer weight = (Integer)game.getWeight(e);
                    Fraction reweighted = new Fraction(weight.intValue()).subtract(mw);
                    if (!PolicyIterationInt.isSmaller(meanPayoffVector.get(v), meanPayoffVector.get(u)) && (!meanPayoffVector.get(v).equals((Object)meanPayoffVector.get(u)) || !PolicyIterationInt.isSmaller(distVector.get(v), distVector.get(u).add(reweighted)))) continue;
                    currentStrategy.setSuccessor(v, u);
                    improvement = true;
                }
            }
        }
        return Tuple.of(meanPayoffVector, currentStrategy);
    }

    protected static <V, E> Triple<Map<V, Fraction>, Map<V, Fraction>, StrategyVector<V, E>> improveStrategyPlayer1(MeanPayoffGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> currentStrategy, Map<V, Fraction> d_prev, Map<V, Fraction> m_prev) {
        int t = -1;
        boolean improvement = true;
        Map<V, Fraction> d_i_t = new HashMap<V, Fraction>(d_prev);
        Map<V, Fraction> m_i_t = new HashMap<V, Fraction>(m_prev);
        StrategyVector s_i_t = new StrategyVector(currentStrategy);
        while (improvement) {
            ++t;
            Tuple<Map<V, Fraction>, Map<V, Fraction>> evalResult = PolicyIterationInt.evaluateStrategy(game, s_i_t, d_prev, m_prev);
            d_i_t = evalResult.getLeft();
            m_i_t = evalResult.getRight();
            improvement = false;
            for (Object v : game.getV1()) {
                for (Object e : game.outgoingEdgesOf(v)) {
                    Object u = game.getEdgeTarget(e);
                    Fraction mw = m_i_t.get(u);
                    Integer weight = (Integer)game.getWeight(e);
                    Fraction reweighted = new Fraction(weight.intValue()).subtract(mw);
                    if (!PolicyIterationInt.isLarger(m_i_t.get(v), m_i_t.get(u)) && (!m_i_t.get(v).equals((Object)m_i_t.get(u)) || !PolicyIterationInt.isLarger(d_i_t.get(v), d_i_t.get(u).add(reweighted)))) continue;
                    s_i_t.setSuccessor(v, u);
                    improvement = true;
                }
            }
        }
        return Triple.of(d_i_t, m_i_t, s_i_t);
    }

    protected static <V, E> Tuple<Map<V, Fraction>, Map<V, Fraction>> evaluateStrategy(MeanPayoffGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> strategy, Map<V, Fraction> distanceVector, Map<V, Fraction> payoffVector) {
        Tuple<Set<V>, Map<V, Fraction>> cycleResult = PolicyIterationInt.findCyclesInRestrictedGraph(game, strategy);
        Map<V, Fraction> m_i_t = cycleResult.getRight();
        Tuple<Map<V, Fraction>, Map<V, Fraction>> cd = PolicyIterationInt.computeDistances(game, strategy, (Collection)cycleResult.getLeft(), m_i_t, distanceVector, payoffVector);
        Map<V, Fraction> d_i_t = cd.getLeft();
        m_i_t = cd.getRight();
        return Tuple.of(d_i_t, m_i_t);
    }

    protected static <V, E> Tuple<Set<V>, Map<V, Fraction>> findCyclesInRestrictedGraph(MeanPayoffGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> currentStrategy) {
        Object BOTTOM_VERTEX = null;
        HashSet selectedVertices = new HashSet();
        Map visited = PolicyIterationInt.initializeVector(game.getVertices(), BOTTOM_VERTEX);
        HashMap m_i_t = new HashMap();
        for (Object v : game.getVertices()) {
            if (visited.get(v) != BOTTOM_VERTEX) continue;
            Object u = v;
            while (visited.get(u) == BOTTOM_VERTEX) {
                visited.put(u, v);
                u = currentStrategy.getSuccessor(u);
            }
            if (visited.get(u) != v) continue;
            Object v_s = u;
            V x = currentStrategy.getSuccessor(u);
            Object e = game.getEdge(u, currentStrategy.getSuccessor(u));
            Integer cycleWeight = (Integer)game.getWeight(e);
            Integer cycleLength = 1;
            while (x != u) {
                if (game.getId(x) < game.getId(v_s)) {
                    v_s = x;
                }
                Object x_sucx = game.getEdge(x, currentStrategy.getSuccessor(x));
                cycleWeight = cycleWeight + (Integer)game.getWeight(x_sucx);
                cycleLength = cycleLength + 1;
                x = currentStrategy.getSuccessor(x);
            }
            m_i_t.put(v_s, new Fraction(cycleWeight.intValue(), cycleLength.intValue()));
            selectedVertices.add(v_s);
        }
        return Tuple.of(selectedVertices, m_i_t);
    }

    protected static <V, E> Tuple<Map<V, Fraction>, Map<V, Fraction>> computeDistances(MeanPayoffGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> currentStrategy, Collection<V> selectedVertices, Map<V, Fraction> m_i_t, Map<V, Fraction> d_prev, Map<V, Fraction> r_prev) {
        Stack<V> stack = new Stack<V>();
        Map<Boolean, Boolean> visited = PolicyIterationInt.initializeVector(game.getVertices(), false);
        HashMap<Object, Fraction> d_i_t = new HashMap<Object, Fraction>();
        for (V u : selectedVertices) {
            if (r_prev.get(u).equals((Object)m_i_t.get(u))) {
                d_i_t.put(u, d_prev.get(u));
            } else {
                d_i_t.put(u, Fraction.ZERO);
            }
            visited.put((Boolean)u, true);
        }
        for (V v : game.getVertices()) {
            if (visited.get(v).booleanValue()) continue;
            Object u = v;
            while (!visited.get(u).booleanValue()) {
                visited.put((Boolean)u, true);
                stack.push(u);
                u = currentStrategy.getSuccessor(u);
            }
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                Object e = game.getEdge(x, u);
                Integer weight = (Integer)game.getWeight(e);
                Fraction cyclePayoff = m_i_t.get(u);
                m_i_t.put((Fraction)x, cyclePayoff);
                d_i_t.put(x, ((Fraction)d_i_t.get(u)).add(weight.intValue()).subtract(m_i_t.get(u)));
                u = x;
            }
        }
        return Tuple.of(d_i_t, m_i_t);
    }

    private static boolean isSmaller(Fraction frac1, Fraction frac2) {
        return frac1.compareTo(frac2) < 0;
    }

    private static boolean isLarger(Fraction frac1, Fraction frac2) {
        return frac1.compareTo(frac2) > 0;
    }

    private static <V, T> Map<V, T> initializeVector(Collection<V> vertices, T value) {
        HashMap vector = new HashMap();
        vertices.stream().forEach(v -> {
            Object object2 = vector.put(v, value);
        });
        return vector;
    }
}

