/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.statespace;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.lsat.common.ludus.backend.algebra.Vector;
import org.eclipse.lsat.common.ludus.backend.statespace.Configuration;
import org.eclipse.lsat.common.ludus.backend.statespace.MaxPlusStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;

public class DOTGenerator {
    private boolean showReward = false;

    public void setReward(boolean showReward) {
        this.showReward = showReward;
    }

    public void generate(MaxPlusStateSpace graph, File outputFile) throws IOException {
        FileWriter fw = new FileWriter(outputFile);
        BufferedWriter output = new BufferedWriter(fw);
        this.printHeader(output);
        HashMap<Configuration, Integer> cidMap = new HashMap<Configuration, Integer>();
        int cid = 0;
        for (Configuration c : graph.getVertices()) {
            this.printConfiguration(output, graph, c, cid);
            cidMap.put(c, cid);
            ++cid;
        }
        for (Transition t : graph.getEdges()) {
            this.printTransition(output, graph, t, (Integer)cidMap.get(t.getSource()), (Integer)cidMap.get(t.getTarget()));
        }
        this.printFooter(output);
        output.close();
        fw.close();
    }

    private void printConfiguration(BufferedWriter output, MaxPlusStateSpace graph, Configuration configuration, Integer cid) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("  c").append(cid);
        sb.append("[texlbl=\"$\\langle ").append(configuration.getLocation().toString()).append(", ").append("\\begin{bmatrix}");
        Vector vec = configuration.getVector();
        int col = 0;
        while (col < vec.size()) {
            sb.append(vec.get(col));
            if (col != vec.size() - 1) {
                sb.append("\\\\");
            }
            ++col;
        }
        sb.append("\\end{bmatrix}\\rangle$\"];\n");
        output.write(sb.toString());
    }

    private void printTransition(BufferedWriter output, MaxPlusStateSpace graph, Transition t, Integer src, Integer tgt) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("  c").append(src).append(" -> ").append("c").append(tgt).append(" [label=\"").append(t.getEvent()).append(",");
        if (this.showReward) {
            sb.append(t.getReward()).append(",");
        }
        sb.append(t.getDuration()).append("\"];\n");
        output.write(sb.toString());
    }

    private void printHeader(BufferedWriter output) throws IOException {
        output.write("digraph statespace {\n  node [shape=none margin=0 width=0 height=0.55];\n");
    }

    private void printFooter(BufferedWriter output) throws IOException {
        output.write("}");
    }
}

