/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.queries;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsat.common.util.BranchIterator;
import org.eclipse.lsat.common.util.BranchUpToIterator;
import org.eclipse.lsat.common.util.BufferedIterator;
import org.eclipse.lsat.common.util.ClosureIterator;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.common.util.IteratorUtil;
import org.eclipse.lsat.common.util.PeekingIterator;
import org.eclipse.lsat.common.util.ProcessingIterator;
import org.eclipse.lsat.common.util.SegmentIterator;
import org.eclipse.lsat.common.util.TreeWalkerIterator;

public class IteratorQueries {
    private IteratorQueries() {
    }

    public static <Input> Iterator<Input> findNearest(final BranchIterator<Input> iterator, final Predicate<? super Input> predicate) {
        return new ProcessingIterator<Input>(){

            @Override
            protected boolean toNext() {
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!predicate.test(next)) continue;
                    boolean result = this.setNext(next);
                    iterator.prune();
                    return result;
                }
                return this.done();
            }
        };
    }

    public static <Input, Output> Iterator<Output> findNearest(BranchIterator<Input> iterator, Class<Output> type) {
        return IteratorQueries.asType(IteratorQueries.findNearest(iterator, type::isInstance), type);
    }

    public static <Input> BranchIterator<Input> until(BranchIterator<Input> iterator, Predicate<? super Input> predicate) {
        return new BranchUpToIterator<Input>(iterator, predicate, false);
    }

    public static <Input> BranchIterator<Input> upToAndIncluding(BranchIterator<Input> iterator, Predicate<? super Input> predicate) {
        return new BranchUpToIterator<Input>(iterator, predicate, true);
    }

    public static <Input> BranchIterator<Input> closure(Iterator<? extends Input> iterator, Function<Input, Iterator<? extends Input>> functor) {
        return IteratorQueries.closure(iterator, false, functor);
    }

    public static <Input> BranchIterator<Input> closure(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, Iterator<? extends Input>> functor) {
        return new ClosureIterator<Input>(iterator, includeSource, functor);
    }

    public static <Input> BranchIterator<Input> closureWhile(Iterator<? extends Input> iterator, Function<Input, Iterator<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.closureWhile(iterator, false, functor, predicate);
    }

    public static <Input> BranchIterator<Input> closureWhile(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, Iterator<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.until(IteratorQueries.closure(iterator, includeSource, functor), predicate.negate());
    }

    public static <Input> BranchIterator<Input> closureOne(Iterator<? extends Input> iterator, Function<Input, ? extends Input> functor) {
        return IteratorQueries.closureOne(iterator, false, functor);
    }

    public static <Input> BranchIterator<Input> closureOne(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, ? extends Input> functor) {
        return new ClosureIterator<Object>(iterator, includeSource, e -> IteratorQueries.toMany(functor.apply(e)));
    }

    public static <Input> BranchIterator<Input> closureOneWhile(Iterator<? extends Input> iterator, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.closureOneWhile(iterator, false, functor, predicate);
    }

    public static <Input> BranchIterator<Input> closureOneWhile(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.until(IteratorQueries.closureOne(iterator, includeSource, functor), predicate.negate());
    }

    public static <Input> BranchIterator<Input> climbTree(Iterator<? extends Input> iterator, Function<Input, ? extends Input> functor) {
        return IteratorQueries.climbTree(iterator, false, functor);
    }

    public static <Input> BranchIterator<Input> climbTree(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, ? extends Input> functor) {
        return new TreeWalkerIterator<Object>(iterator, includeSource, e -> IteratorQueries.toMany(functor.apply(e)));
    }

    public static <Input> BranchIterator<Input> climbTreeWhile(Iterator<? extends Input> iterator, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.climbTreeWhile(iterator, false, functor, predicate);
    }

    public static <Input> BranchIterator<Input> climbTreeWhile(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.until(IteratorQueries.climbTree(iterator, includeSource, functor), predicate.negate());
    }

    public static <Input> BranchIterator<Input> walkTree(Iterator<? extends Input> iterator, Function<Input, Iterator<? extends Input>> functor) {
        return IteratorQueries.walkTree(iterator, false, functor);
    }

    public static <Input> BranchIterator<Input> walkTree(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, Iterator<? extends Input>> functor) {
        return new TreeWalkerIterator<Input>(iterator, includeSource, functor);
    }

    public static <Input> BranchIterator<Input> walkTreeWhile(Iterator<? extends Input> iterator, Function<Input, Iterator<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.walkTreeWhile(iterator, false, functor, predicate);
    }

    public static <Input> BranchIterator<Input> walkTreeWhile(Iterator<? extends Input> iterator, boolean includeSource, Function<Input, Iterator<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IteratorQueries.until(IteratorQueries.walkTree(iterator, includeSource, functor), predicate.negate());
    }

    public static <Input> Iterator<Input> select(Iterator<Input> iterator, Predicate<? super Input> predicate) {
        return IteratorUtil.filter(iterator, predicate);
    }

    public static <Input> Iterator<Input> xselect(Iterator<Input> iterator, Predicate<? super Input> functor) {
        return IteratorQueries.select(IteratorUtil.notNull(iterator), functor);
    }

    public static <Input> Iterator<Input> reject(Iterator<Input> iterator, Predicate<? super Input> functor) {
        return IteratorQueries.select(iterator, functor.negate());
    }

    public static <Input, Output> Iterator<Output> objectsOfKind(Iterator<Input> iterator, Class<Output> outputType) {
        return IteratorQueries.xcollectOne(iterator, input -> outputType.isInstance(input) ? outputType.cast(input) : null);
    }

    public static <Input, Output> Iterator<Output> objectsOfType(Iterator<Input> iterator, Class<Output> outputType) {
        Function<Object, Object> functor = outputType.isInterface() ? i -> i != null && IterableUtil.asList(i.getClass().getInterfaces()).contains(outputType) ? outputType.cast(i) : null : i -> i != null && i.getClass().equals(outputType) ? outputType.cast(i) : null;
        return IteratorQueries.xcollectOne(iterator, functor);
    }

    public static <Input, Output> Iterator<Output> asType(Iterator<Input> iterator, Class<Output> outputType) {
        return IteratorQueries.collectOne(iterator, outputType::cast);
    }

    public static <Input, Output> Iterator<Output> collect(Iterator<? extends Input> iterator, Function<Input, Iterator<? extends Output>> functor) {
        return IteratorUtil.flatMap(iterator, functor);
    }

    public static <Input, Output> Iterator<Output> xcollect(Iterator<? extends Input> iterator, Function<Input, Iterator<? extends Output>> functor) {
        return IteratorUtil.notNull(IteratorQueries.collect(iterator, functor));
    }

    public static <Input, Output> Iterator<Output> collectOne(Iterator<? extends Input> iterator, Function<Input, Output> functor) {
        return IteratorUtil.map(iterator, functor);
    }

    public static <Input, Output> Iterator<Output> xcollectOne(Iterator<? extends Input> iterator, Function<Input, Output> functor) {
        return IteratorUtil.notNull(IteratorQueries.collectOne(iterator, functor));
    }

    public static <Input> boolean forAll(Iterator<? extends Input> iterator, Predicate<Input> functor) {
        return !IteratorQueries.exists(iterator, functor.negate());
    }

    public static <Input> boolean exists(Iterator<? extends Input> iterator, Predicate<Input> functor) {
        return IteratorQueries.select(iterator, functor).hasNext();
    }

    public static <Input> Input any(Iterator<Input> iterator, Predicate<? super Input> functor) {
        return IteratorUtil.safeNext(IteratorQueries.select(iterator, functor));
    }

    public static <InputA, InputB> Iterator<Pair<InputA, InputB>> zip(final Iterator<? extends InputA> iteratorA, final Iterator<? extends InputB> iteratorB) {
        return new ProcessingIterator<Pair<InputA, InputB>>(){

            @Override
            protected boolean toNext() {
                if (iteratorA.hasNext() && iteratorB.hasNext()) {
                    return this.setNext(Pair.of(iteratorA.next(), iteratorB.next()));
                }
                return this.done();
            }
        };
    }

    public static <InputA, InputB> Iterator<Pair<InputA, InputB>> zip(final Iterator<? extends InputA> iteratorA, final Iterator<? extends InputB> iteratorB, final boolean includeOneSideOnly, int offset) {
        return new ProcessingIterator<Pair<InputA, InputB>>(offset){
            int indexA;
            int indexB;
            {
                this.indexA = n > 0 ? 0 : n;
                this.indexB = n > 0 ? -n : 0;
            }

            @Override
            protected boolean toNext() {
                while (iteratorA.hasNext() || iteratorB.hasNext()) {
                    ++this.indexA;
                    ++this.indexB;
                    boolean gotA = false;
                    Object a = null;
                    if (this.indexA > 0 && iteratorA.hasNext()) {
                        a = iteratorA.next();
                        gotA = true;
                    }
                    boolean gotB = false;
                    Object b = null;
                    if (this.indexB > 0 && iteratorB.hasNext()) {
                        b = iteratorB.next();
                        gotB = true;
                    }
                    if (!includeOneSideOnly && (!gotA || !gotB)) continue;
                    return this.setNext(Pair.of(a, b));
                }
                return this.done();
            }
        };
    }

    public static <InputA, InputB> Iterator<Pair<InputA, InputB>> zip(Iterator<? extends InputA> iteratorA, Iterator<? extends InputB> iteratorB, final ToIntBiFunction<? super InputA, ? super InputB> comparator) {
        return new ProcessingIterator<Pair<InputA, InputB>>(iteratorA, iteratorB){
            private final PeekingIterator<? extends InputA> left;
            private final PeekingIterator<? extends InputB> right;
            {
                this.left = IteratorUtil.toPeeking(iterator);
                this.right = IteratorUtil.toPeeking(iterator2);
            }

            @Override
            protected boolean toNext() {
                if (this.left.hasNext() && this.right.hasNext()) {
                    int compare = comparator.applyAsInt(this.left.peek(), this.right.peek());
                    if (compare == 0) {
                        return this.setNext(Pair.of(this.left.next(), this.right.next()));
                    }
                    if (compare < 0) {
                        return this.setNext(Pair.of(this.left.next(), null));
                    }
                    return this.setNext(Pair.of(null, this.right.next()));
                }
                if (this.left.hasNext()) {
                    return this.setNext(Pair.of(this.left.next(), null));
                }
                if (this.right.hasNext()) {
                    return this.setNext(Pair.of(null, this.right.next()));
                }
                return this.done();
            }
        };
    }

    public static <InputA, InputB> Iterator<Pair<InputA, InputB>> product(final Iterator<? extends InputA> iteratorA, Iterator<? extends InputB> iteratorB) {
        final BufferedIterator<InputB> bufferedInputB = new BufferedIterator<InputB>(iteratorB);
        bufferedInputB.mark();
        return new ProcessingIterator<Pair<InputA, InputB>>(){
            private boolean initialized = false;
            private InputA currentInputA = null;

            @Override
            protected boolean toNext() {
                if (!this.initialized) {
                    this.initialized = true;
                    if (iteratorA.hasNext()) {
                        this.currentInputA = iteratorA.next();
                    } else {
                        return this.done();
                    }
                }
                if (!bufferedInputB.hasNext()) {
                    if (iteratorA.hasNext()) {
                        this.currentInputA = iteratorA.next();
                        bufferedInputB.reset();
                        if (!bufferedInputB.hasNext()) {
                            return this.done();
                        }
                    } else {
                        return this.done();
                    }
                }
                return this.setNext(Pair.of(this.currentInputA, bufferedInputB.next()));
            }
        };
    }

    public static <Input, K> Map<K, Input> toMap(Iterator<Input> iterator, Function<? super Input, K> computeKeys) {
        return IteratorQueries.toMap(iterator, computeKeys, v -> v);
    }

    public static <Input, K, V> Map<K, V> toMap(Iterator<Input> iterator, Function<? super Input, K> computeKeys, Function<? super Input, V> computeValues) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        while (iterator.hasNext()) {
            Input next = iterator.next();
            result.put(computeKeys.apply(next), computeValues.apply(next));
        }
        return result;
    }

    public static <Input, K> Map<K, List<Input>> groupBy(Iterator<Input> iterator, Function<? super Input, K> computeKeys) {
        LinkedHashMap<Object, List> result = new LinkedHashMap<Object, List>();
        while (iterator.hasNext()) {
            Input next = iterator.next();
            result.computeIfAbsent(computeKeys.apply(next), k -> new LinkedList()).add(next);
        }
        return result;
    }

    public static <Input, K, V> Map<K, V> groupByAndReduce(Iterator<Input> iterator, Function<? super Input, K> computeKeys, BiFunction<? super Input, V, ? extends V> computeValues) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            result.compute(computeKeys.apply(next), (A, B) -> computeValues.apply((Object)next, (Object)B));
        }
        return result;
    }

    public static <Input> List<List<Input>> groupBy(Iterator<Input> source, BiPredicate<? super Input, ? super Input> equivalence) {
        return IteratorQueries.groupBy(source, null, equivalence);
    }

    public static <Input> List<List<Input>> groupBy(Iterator<Input> source, Comparator<? super List<Input>> comparator, BiPredicate<? super Input, ? super Input> equivalence) {
        LinkedList<List<Input>> groups = new LinkedList<List<Input>>();
        while (source.hasNext()) {
            Object element = source.next();
            LinkedList<Input> group = IteratorQueries.any(groups.iterator(), g -> equivalence.test((Object)element, (Object)IterableUtil.first(g)));
            if (group == null) {
                group = new LinkedList<Input>();
                groups.add(group);
            }
            group.add(element);
            if (comparator == null) continue;
            groups.sort(comparator);
        }
        return groups;
    }

    public static <Input> Iterator<List<Input>> segment(Iterator<Input> source, BiPredicate<? super Input, ? super Input> predicate) {
        return new SegmentIterator<Input>(source, predicate);
    }

    private static <T> Iterator<T> toMany(T element) {
        return element == null ? Collections.emptyIterator() : IteratorUtil.singletonIterator(element);
    }
}

