/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.timing;

import java.util.Map;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;

/**
 * An Engine that executes JavaScript.
 */
public class JavaScriptEngine {

    // TODO: Currently the javascript engine is hardcoded to nashorn instead of using the SPI.
    private final ScriptEngine scriptEngine = new NashornScriptEngineFactory().getScriptEngine();

    public Object eval(String script, Map<String, Object> args) throws ScriptException {
        Bindings scriptEngineBindings = scriptEngine.createBindings();
        scriptEngineBindings.putAll(args);
        try {
            return scriptEngine.eval(script, scriptEngineBindings);
        } finally {
            args.putAll(scriptEngineBindings);
        }
    }

}
