/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.layout;

import activity.ActivityPackage;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import machine.MachinePackage;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.lsat.activity.diagram.layout.ActivityDiagramLayoutOptions;
import org.eclipse.lsat.activity.diagram.layout.ElkGlobalCoordinates;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDiagramLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityDiagramLayout.class);
    private static final double rowHeight = 60.0;
    private static final double actionSpacingX = 20.0;
    private static final double actionWidth = 140.0;
    private static final double actionHeight = 50.0;
    private static final double syncBarHeight = 10.0;
    private static final double syncBarSpacingY = 20.0;
    private static final double resourceSpacingX = 35.0;
    private static final double resourcePaddingY = 11.0;
    private static final double claimReleaseSpacingX = 10.0;
    private static final double peripheralPaddingX = 2.0;
    private static final double peripheralPaddingY = 28.0;
    private static final double peripheralWidth = 180.0;
    private static final double eventSpacingX = 35.0;
    private static final double eventWidth = 140.0;
    private static final double eventHeight = 50.0;

    private void layout(ElkNode layoutGraph) {
        boolean _isActivity = ActivityDiagramLayout.isActivity((ElkGraphElement)layoutGraph);
        if (_isActivity) {
            double canvasMinX = 0.0;
            double canvasMaxX = this.layoutResources(layoutGraph, 0.0);
            canvasMaxX = this.layoutEvents(layoutGraph, canvasMaxX + 35.0);
            this.layoutSyncBars(layoutGraph, 0.0, canvasMaxX);
            this.layoutEdges(layoutGraph);
        }
    }

    private double layoutResources(ElkNode topNode, double startX) {
        double resourceX = startX;
        Functions.Function1 _function = it -> ActivityDiagramLayout.isResource((ElkGraphElement)it);
        Iterable _filter = IterableExtensions.filter((Iterable)topNode.getChildren(), (Functions.Function1)_function);
        for (ElkNode resourceNode : _filter) {
            Functions.Function1 _function_1 = it -> ActivityDiagramLayout.isClaim((ElkGraphElement)it);
            Functions.Function1 _function_2 = it -> ActivityDiagramLayout.getLayoutRow((ElkGraphElement)it);
            Integer claimRowNumber = (Integer)Queries.max((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)resourceNode.getPorts(), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Comparable)Integer.valueOf(0));
            Functions.Function1 _function_3 = it -> ActivityDiagramLayout.isRelease((ElkGraphElement)it);
            Functions.Function1 _function_4 = it -> ActivityDiagramLayout.getLayoutRow((ElkGraphElement)it);
            Integer releaseRowNumber = (Integer)Queries.max((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)resourceNode.getPorts(), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Comparable)Integer.valueOf(0));
            double peripheralHeight = (double)(releaseRowNumber - claimRowNumber) * 60.0;
            int _size = resourceNode.getChildren().size();
            double peripheralsWidth = (double)_size * 182.0;
            ElkGlobalCoordinates.setGlobalLocation((ElkShape)resourceNode, resourceX, ActivityDiagramLayout.toGlobalY(claimRowNumber));
            resourceNode.setDimensions(peripheralsWidth, peripheralHeight + 11.0);
            this.layoutPeripherals(resourceNode, peripheralHeight);
            this.layoutClaimsAndReleases(resourceNode);
            double _resourceX = resourceX;
            double _width = resourceNode.getWidth();
            double _plus = _width + 35.0;
            resourceX = _resourceX + _plus;
        }
        return Math.max(resourceX - 35.0, startX);
    }

    private double layoutEvents(ElkNode topNode, double startX) {
        double eventX = startX;
        Functions.Function1 _function = it -> ActivityDiagramLayout.isEventAction((ElkGraphElement)it);
        Functions.Function1 _function_1 = it -> ActivityDiagramLayout.getEventName((ElkGraphElement)it);
        Functions.Function1 _function_2 = it -> (String)it.getKey();
        List _sortBy = IterableExtensions.sortBy(IterableExtensions.groupBy((Iterable)Queries.xselect((Iterable)topNode.getChildren(), (Functions.Function1)_function), (Functions.Function1)_function_1).entrySet(), (Functions.Function1)_function_2);
        for (Map.Entry events : _sortBy) {
            List _value = (List)events.getValue();
            for (ElkNode eventNode : _value) {
                eventNode.setLocation(eventX, ActivityDiagramLayout.toGlobalY(ActivityDiagramLayout.getLayoutRow((ElkGraphElement)eventNode)));
                eventNode.setDimensions(140.0, 50.0);
            }
            double _eventX = eventX;
            eventX = _eventX + 175.0;
        }
        return Math.max(eventX - 35.0, startX);
    }

    private void layoutPeripherals(ElkNode resourceNode, double peripheralHeight) {
        double peripheralX = 0.0;
        Functions.Function1 _function = it -> ActivityDiagramLayout.isResource((ElkGraphElement)it);
        Iterable _xselect = Queries.xselect((Iterable)resourceNode.getChildren(), (Functions.Function1)_function);
        for (ElkNode resourcePlaceholder : _xselect) {
            resourcePlaceholder.setLocation(peripheralX, 0.0);
            resourcePlaceholder.setDimensions(180.0, peripheralHeight);
            double _peripheralX = peripheralX;
            peripheralX = _peripheralX + 180.0;
        }
        Functions.Function1 _function_1 = it -> ActivityDiagramLayout.isPeripheral((ElkGraphElement)it);
        Iterable _xselect_1 = Queries.xselect((Iterable)resourceNode.getChildren(), (Functions.Function1)_function_1);
        for (ElkNode peripheral : _xselect_1) {
            peripheral.setLocation(peripheralX, 0.0);
            peripheral.setDimensions(180.0, peripheralHeight);
            this.layoutActions(peripheral);
            double _peripheralX = peripheralX;
            peripheralX = _peripheralX + 180.0;
        }
    }

    private void layoutActions(ElkNode peripheralNode) {
        double peripheralGlobalY = ElkGlobalCoordinates.getGlobalLocation((ElkShape)peripheralNode).y + 28.0;
        Functions.Function1 _function = it -> ActivityDiagramLayout.isAction((ElkGraphElement)it);
        Iterable _xselect = Queries.xselect((Iterable)peripheralNode.getChildren(), (Functions.Function1)_function);
        for (ElkNode action : _xselect) {
            double _globalY = ActivityDiagramLayout.toGlobalY(ActivityDiagramLayout.getLayoutRow((ElkGraphElement)action));
            double _minus = _globalY - peripheralGlobalY;
            action.setLocation(20.0, _minus);
            action.setDimensions(140.0, 50.0);
        }
    }

    private void layoutClaimsAndReleases(ElkNode resource) {
        EList _ports = resource.getPorts();
        for (ElkPort port : _ports) {
            boolean _isClaim = ActivityDiagramLayout.isClaim((ElkGraphElement)port);
            if (_isClaim) {
                port.setLocation(10.0, 0.0);
                continue;
            }
            boolean _isRelease = ActivityDiagramLayout.isRelease((ElkGraphElement)port);
            if (!_isRelease) continue;
            port.setLocation(10.0, resource.getHeight());
        }
    }

    private void layoutEdges(ElkNode topNode) {
        Functions.Function1 _function = it -> it.getChildren();
        Functions.Function1 _function_1 = it -> it.getContainedEdges();
        Iterable allEdges = Queries.collect((Iterable)Queries.closure(Collections.singleton(topNode), (boolean)true, (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.isConnected();
        Iterable _filter = IterableExtensions.filter((Iterable)allEdges, (Functions.Function1)_function_2);
        for (ElkEdge edge : _filter) {
            ElkNode _parent = edge.getContainingNode().getParent();
            boolean containedByRoot = _parent == null;
            ElkEdgeSection section = this.straighten(edge);
            ElkConnectableShape source = ActivityDiagramLayout.source(edge);
            ElkConnectableShape target = ActivityDiagramLayout.target(edge);
            Point2D.Double sourceOrgGlbLoc = ElkGlobalCoordinates.getGlobalStartLocation(section);
            Point2D.Double targetOrgGlbLoc = ElkGlobalCoordinates.getGlobalEndLocation(section);
            Rectangle2D.Double sourceBounds = ElkGlobalCoordinates.getGlobalBounds((ElkShape)source);
            Rectangle2D.Double targetBounds = ElkGlobalCoordinates.getGlobalBounds((ElkShape)target);
            if (containedByRoot) {
                ElkGlobalCoordinates.translate(sourceBounds, 100.0, 35.0);
                ElkGlobalCoordinates.translate(targetBounds, 100.0, 35.0);
            }
            if (sourceBounds.x > targetBounds.getMaxX() || targetBounds.x > sourceBounds.getMaxX()) {
                ElkGlobalCoordinates.setGlobalStartLocation(section, sourceBounds.getCenterX(), sourceBounds.getCenterY());
                ElkGlobalCoordinates.setGlobalEndLocation(section, targetBounds.getCenterX(), targetBounds.getCenterY());
            } else {
                double _max = Math.max(sourceBounds.x, targetBounds.x);
                double _min = Math.min(sourceBounds.getMaxX(), targetBounds.getMaxX());
                double _plus = _max + _min;
                double centerX = _plus / 2.0;
                ElkGlobalCoordinates.setGlobalStartLocation(section, centerX, sourceBounds.getCenterY());
                ElkGlobalCoordinates.setGlobalEndLocation(section, centerX, targetBounds.getCenterY());
            }
            Point2D.Double sourceLydGlbLoc = ElkGlobalCoordinates.getGlobalStartLocation(section);
            Point2D.Double targetLydGlbLoc = ElkGlobalCoordinates.getGlobalEndLocation(section);
            StringConcatenation _builder = new StringConcatenation();
            String _name = ActivityDiagramLayout.getName((ElkGraphElement)source);
            _builder.append(_name);
            _builder.append(" [");
            _builder.append((Object)(sourceLydGlbLoc.x - sourceOrgGlbLoc.x));
            _builder.append(", ");
            _builder.append((Object)(sourceLydGlbLoc.y - sourceOrgGlbLoc.y));
            _builder.append("] ");
            if (!containedByRoot) {
                _builder.append("-");
            }
            _builder.append("-> ");
            String _name_1 = ActivityDiagramLayout.getName((ElkGraphElement)target);
            _builder.append(_name_1);
            _builder.append(" [");
            _builder.append((Object)(targetLydGlbLoc.x - targetOrgGlbLoc.x));
            _builder.append(", ");
            _builder.append((Object)(targetLydGlbLoc.y - targetOrgGlbLoc.y));
            _builder.append("]");
            LOGGER.debug(_builder.toString());
        }
    }

    private ElkEdgeSection straighten(ElkEdge edge) {
        ElkEdgeSection section = (ElkEdgeSection)IterableExtensions.head((Iterable)edge.getSections());
        edge.getSections().retainAll(Collections.singleton(section));
        section.getBendPoints().clear();
        return section;
    }

    private void layoutSyncBars(ElkNode topNode, double minX, double maxX) {
        Functions.Function1 _function = it -> ActivityDiagramLayout.isSyncBar((ElkGraphElement)it);
        Iterable _xselect = Queries.xselect((Iterable)topNode.getChildren(), (Functions.Function1)_function);
        for (ElkNode syncBar : _xselect) {
            Functions.Function1 _function_1 = it -> ActivityDiagramLayout.source(it);
            Functions.Function1 _function_2 = it -> ActivityDiagramLayout.target(it);
            Iterable adjacentNodes = Queries.union((Iterable)ListExtensions.map((List)syncBar.getIncomingEdges(), (Functions.Function1)_function_1), (Iterable)ListExtensions.map((List)syncBar.getOutgoingEdges(), (Functions.Function1)_function_2));
            Functions.Function1 _function_3 = it -> ActivityDiagramLayout.isSyncBar((ElkGraphElement)it);
            Set adjacentLaidOutNodes = IterableExtensions.toSet((Iterable)IterableExtensions.reject((Iterable)adjacentNodes, (Functions.Function1)_function_3));
            double _globalY = ActivityDiagramLayout.toGlobalY(ActivityDiagramLayout.getLayoutRow((ElkGraphElement)syncBar));
            double syncBarY = _globalY + 20.0;
            boolean _isEmpty = adjacentLaidOutNodes.isEmpty();
            if (_isEmpty) {
                syncBar.setLocation(minX, syncBarY);
                syncBar.setDimensions(maxX - minX, 10.0);
                continue;
            }
            Functions.Function1 _function_4 = it -> ElkGlobalCoordinates.getGlobalLocation((ElkShape)it).x;
            Double adjecentMinX = (Double)IterableExtensions.min((Iterable)IterableExtensions.map((Iterable)adjacentLaidOutNodes, (Functions.Function1)_function_4));
            Functions.Function1 _function_5 = it -> {
                double _width = it.getWidth();
                return ElkGlobalCoordinates.getGlobalLocation((ElkShape)it).x + _width;
            };
            Double adjecentMaxX = (Double)IterableExtensions.max((Iterable)IterableExtensions.map((Iterable)adjacentLaidOutNodes, (Functions.Function1)_function_5));
            syncBar.setLocation(adjecentMinX.doubleValue(), syncBarY);
            double _minus = DoubleExtensions.operator_minus((Double)adjecentMaxX, (Number)adjecentMinX);
            syncBar.setDimensions(_minus, 10.0);
        }
    }

    private static ElkConnectableShape source(ElkEdge edge) {
        return (ElkConnectableShape)IterableExtensions.head((Iterable)edge.getSources());
    }

    private static ElkConnectableShape target(ElkEdge edge) {
        return (ElkConnectableShape)IterableExtensions.head((Iterable)edge.getTargets());
    }

    private static boolean isActivity(ElkGraphElement node) {
        EClass _layoutEClass = ActivityDiagramLayout.getLayoutEClass(node);
        return _layoutEClass == ActivityPackage.Literals.ACTIVITY;
    }

    private static boolean isAction(ElkGraphElement node) {
        return ActivityPackage.Literals.ACTION.isSuperTypeOf(ActivityDiagramLayout.getLayoutEClass(node));
    }

    private static boolean isPeripheral(ElkGraphElement node) {
        EClass _layoutEClass = ActivityDiagramLayout.getLayoutEClass(node);
        return _layoutEClass == MachinePackage.Literals.PERIPHERAL;
    }

    private static boolean isResource(ElkGraphElement node) {
        return MachinePackage.Literals.IRESOURCE.isSuperTypeOf(ActivityDiagramLayout.getLayoutEClass(node));
    }

    private static boolean isEventAction(ElkGraphElement node) {
        return ActivityPackage.Literals.EVENT_ACTION.isSuperTypeOf(ActivityDiagramLayout.getLayoutEClass(node));
    }

    private static boolean isSyncBar(ElkGraphElement node) {
        EClass _layoutEClass = ActivityDiagramLayout.getLayoutEClass(node);
        return _layoutEClass == ActivityPackage.Literals.SYNC_BAR;
    }

    private static boolean isClaim(ElkGraphElement port) {
        EClass _layoutEClass = ActivityDiagramLayout.getLayoutEClass(port);
        return _layoutEClass == ActivityPackage.Literals.CLAIM;
    }

    private static boolean isRelease(ElkGraphElement port) {
        EClass _layoutEClass = ActivityDiagramLayout.getLayoutEClass(port);
        return _layoutEClass == ActivityPackage.Literals.RELEASE;
    }

    private static EClass getLayoutEClass(ElkGraphElement element) {
        return (EClass)element.getProperty(ActivityDiagramLayoutOptions.E_CLASS);
    }

    private static String getName(ElkGraphElement element) {
        return (String)element.getProperty(ActivityDiagramLayoutOptions.NAME);
    }

    private static String getEventName(ElkGraphElement element) {
        return (String)element.getProperty(ActivityDiagramLayoutOptions.EVENT_NAME);
    }

    private static Integer getLayoutRow(ElkGraphElement element) {
        return (Integer)element.getProperty(ActivityDiagramLayoutOptions.LAYOUT_ROW);
    }

    public static ElkPadding getPadding(IPropertyHolder propertyHolder) {
        return (ElkPadding)propertyHolder.getProperty(CoreOptions.PADDING);
    }

    private static double toGlobalY(Integer rowNumber) {
        return (double)rowNumber.intValue() * 60.0;
    }

    public static class Provider
    extends AbstractLayoutProvider {
        public String getDefaultLayoutAlgorithmID() {
            return "org.eclipse.lsat.activity.diagram.layout.ActivityDiagramLayout";
        }

        public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
            progressMonitor.begin("Activity Diagram Layout", 1.0f);
            new ActivityDiagramLayout().layout(layoutGraph);
            progressMonitor.done();
        }
    }
}

