/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt.api.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.backend.algebra.DenseMatrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.mpt.Matrix;
import org.eclipse.lsat.common.mpt.RowVector;

public class MatrixAdapter {
    private MatrixAdapter() {
    }

    public static Tuple<DenseMatrix, List<String>> getMatrix(Matrix matrix) {
        return MatrixAdapter.getMatrix(matrix, new HashSet<Integer>());
    }

    public static Tuple<DenseMatrix, List<String>> getMatrix(Matrix matrix, Collection<Integer> resourcesToRemove) {
        int size = matrix.getRows().size() - resourcesToRemove.size();
        DenseMatrix dm = new DenseMatrix(size, size);
        ArrayList<Integer> idMapping = new ArrayList<Integer>(size);
        int resId2 = 0;
        while (resId2 < matrix.getRows().size()) {
            if (!resourcesToRemove.contains(resId2)) {
                idMapping.add(resId2);
            }
            ++resId2;
        }
        int row = 0;
        while (row < size) {
            int col = 0;
            while (col < size) {
                Double value = (Double)((RowVector)matrix.getRows().get(((Integer)idMapping.get(row)).intValue())).getValues().get(((Integer)idMapping.get(col)).intValue());
                Double scaledValue = value * 1000000.0;
                Double newValue = MatrixAdapter.round(scaledValue, 0);
                dm.put(row, col, new Value(newValue));
                ++col;
            }
            ++row;
        }
        List resourceNames = idMapping.stream().map(resId -> ((RowVector)matrix.getRows().get(resId.intValue())).getName()).collect(Collectors.toList());
        return Tuple.of(dm, resourceNames);
    }

    private static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        if (value < 0.0) {
            return value;
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

