/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.design;

import activity.Activity;
import activity.PeripheralAction;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.lsat.activity.diagram.services.ActivityServices;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.lsat.activity.diagram.design";
    private final String timeFilterID = "Show Activity Time";
    private static Activator plugin;
    private static Set<Viewpoint> viewpoints;
    private SessionManagerListener sessionListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        viewpoints = new HashSet<Viewpoint>();
        viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("org.eclipse.lsat.activity.diagram.design/description/diagram.odesign"));
        this.sessionListener = new SessionManagerListener.Stub(){

            public void notify(Session session, int notification) {
                if (notification == 7) {
                    Activator.this.registerTimeFilterEvents(session);
                }
            }
        };
        SessionManager.INSTANCE.addSessionsListener(this.sessionListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (viewpoints != null) {
            for (Viewpoint viewpoint : viewpoints) {
                ViewpointRegistry.getInstance().disposeFromPlugin(viewpoint);
            }
            viewpoints.clear();
            viewpoints = null;
        }
        if (this.sessionListener != null) {
            SessionManager.INSTANCE.removeSessionsListener(this.sessionListener);
        }
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void registerTimeFilterEvents(Session session) {
        EContentAdapter adapter = new EContentAdapter(){

            /*
             * WARNING - void declaration
             */
            public void notifyChanged(Notification notification) {
                void diagram;
                Object object;
                EStructuralFeature feature;
                super.notifyChanged(notification);
                Object object2 = notification.getFeature();
                if (!(object2 instanceof EStructuralFeature && "activatedFilters".equals((feature = (EStructuralFeature)object2).getName()) && (object = notification.getNotifier()) instanceof DDiagram)) {
                    return;
                }
                DDiagram dDiagram = (DDiagram)object;
                Optional<FilterDescription> targetFilter = diagram.getDescription().getFilters().stream().filter(f -> "Show Activity Time".equals(f.getName())).findFirst();
                if (targetFilter.isEmpty()) {
                    return;
                }
                boolean active = diagram.getActivatedFilters().contains((Object)targetFilter.get());
                Activator.this.updateTimingLabelVisibility((DDiagram)diagram, active);
                DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        session.getTransactionalEditingDomain().getResourceSet().eAdapters().add((Object)adapter);
    }

    private void updateTimingLabelVisibility(final DDiagram diagram, final boolean showTimingLabels) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        if (domain == null) {
            return;
        }
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                for (DDiagramElement element : diagram.getDiagramElements()) {
                    PeripheralAction action;
                    EObject target = element.getTarget();
                    if (!(target instanceof PeripheralAction) || !((action = (PeripheralAction)target).getGraph() instanceof Activity)) continue;
                    ActivityServices.setShowTimeLabels(diagram, showTimingLabels);
                }
            }
        });
    }
}

