/**
 */
package distributions;

import expressions.ExpressionsPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see distributions.DistributionsFactory
 * @model kind="package"
 * @generated
 */
public interface DistributionsPackage extends EPackage
{
    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "distributions";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http://www.eclipse.org/lsat/distributions";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "distributions";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    DistributionsPackage eINSTANCE = distributions.impl.DistributionsPackageImpl.init();

    /**
     * The meta object id for the '{@link distributions.Distribution <em>Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.Distribution
     * @see distributions.impl.DistributionsPackageImpl#getDistribution()
     * @generated
     */
    int DISTRIBUTION = 0;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION__NAME = ExpressionsPackage.EXPRESSION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION__DEFAULT = ExpressionsPackage.EXPRESSION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION__DEFAULT_EXP = ExpressionsPackage.EXPRESSION_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = ExpressionsPackage.EXPRESSION_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION_FEATURE_COUNT = ExpressionsPackage.EXPRESSION_FEATURE_COUNT + 3;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION___EVALUATE = ExpressionsPackage.EXPRESSION_OPERATION_COUNT + 0;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = ExpressionsPackage.EXPRESSION_OPERATION_COUNT + 1;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION___GET_MODE_DISTRIBUTION = ExpressionsPackage.EXPRESSION_OPERATION_COUNT + 2;

    /**
     * The number of operations of the '<em>Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DISTRIBUTION_OPERATION_COUNT = ExpressionsPackage.EXPRESSION_OPERATION_COUNT + 3;

    /**
     * The meta object id for the '{@link distributions.impl.TriangularDistributionImpl <em>Triangular Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.impl.TriangularDistributionImpl
     * @see distributions.impl.DistributionsPackageImpl#getTriangularDistribution()
     * @generated
     */
    int TRIANGULAR_DISTRIBUTION = 1;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__NAME = DISTRIBUTION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__DEFAULT = DISTRIBUTION__DEFAULT;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__DEFAULT_EXP = DISTRIBUTION__DEFAULT_EXP;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE;

    /**
     * The feature id for the '<em><b>Mode</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__MODE = DISTRIBUTION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Min</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__MIN = DISTRIBUTION_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Max</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__MAX = DISTRIBUTION_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Mode Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__MODE_EXP = DISTRIBUTION_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Min Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__MIN_EXP = DISTRIBUTION_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Max Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION__MAX_EXP = DISTRIBUTION_FEATURE_COUNT + 5;

    /**
     * The number of structural features of the '<em>Triangular Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 6;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION___EVALUATE = DISTRIBUTION___EVALUATE;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION___GET_MODE_DISTRIBUTION = DISTRIBUTION___GET_MODE_DISTRIBUTION;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = DISTRIBUTION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Triangular Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TRIANGULAR_DISTRIBUTION_OPERATION_COUNT = DISTRIBUTION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link distributions.impl.PertDistributionImpl <em>Pert Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.impl.PertDistributionImpl
     * @see distributions.impl.DistributionsPackageImpl#getPertDistribution()
     * @generated
     */
    int PERT_DISTRIBUTION = 2;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__NAME = DISTRIBUTION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__DEFAULT = DISTRIBUTION__DEFAULT;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__DEFAULT_EXP = DISTRIBUTION__DEFAULT_EXP;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE;

    /**
     * The feature id for the '<em><b>Mode</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__MODE = DISTRIBUTION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Min</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__MIN = DISTRIBUTION_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Max</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__MAX = DISTRIBUTION_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Mode Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__MODE_EXP = DISTRIBUTION_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Min Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__MIN_EXP = DISTRIBUTION_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Max Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__MAX_EXP = DISTRIBUTION_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Gamma</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__GAMMA = DISTRIBUTION_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Gamma Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION__GAMMA_EXP = DISTRIBUTION_FEATURE_COUNT + 7;

    /**
     * The number of structural features of the '<em>Pert Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 8;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION___EVALUATE = DISTRIBUTION___EVALUATE;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION___GET_MODE_DISTRIBUTION = DISTRIBUTION___GET_MODE_DISTRIBUTION;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = DISTRIBUTION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Pert Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PERT_DISTRIBUTION_OPERATION_COUNT = DISTRIBUTION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link distributions.impl.NormalDistributionImpl <em>Normal Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.impl.NormalDistributionImpl
     * @see distributions.impl.DistributionsPackageImpl#getNormalDistribution()
     * @generated
     */
    int NORMAL_DISTRIBUTION = 3;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__NAME = DISTRIBUTION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__DEFAULT = DISTRIBUTION__DEFAULT;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__DEFAULT_EXP = DISTRIBUTION__DEFAULT_EXP;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE;

    /**
     * The feature id for the '<em><b>Mean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__MEAN = DISTRIBUTION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Sd</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__SD = DISTRIBUTION_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Mean Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__MEAN_EXP = DISTRIBUTION_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Sd Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION__SD_EXP = DISTRIBUTION_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Normal Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 4;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION___EVALUATE = DISTRIBUTION___EVALUATE;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION___GET_MODE_DISTRIBUTION = DISTRIBUTION___GET_MODE_DISTRIBUTION;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = DISTRIBUTION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Normal Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NORMAL_DISTRIBUTION_OPERATION_COUNT = DISTRIBUTION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link distributions.impl.EnumeratedDistributionImpl <em>Enumerated Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.impl.EnumeratedDistributionImpl
     * @see distributions.impl.DistributionsPackageImpl#getEnumeratedDistribution()
     * @generated
     */
    int ENUMERATED_DISTRIBUTION = 4;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION__NAME = DISTRIBUTION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION__DEFAULT = DISTRIBUTION__DEFAULT;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION__DEFAULT_EXP = DISTRIBUTION__DEFAULT_EXP;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE;

    /**
     * The feature id for the '<em><b>Values</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION__VALUES = DISTRIBUTION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Values Exp</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION__VALUES_EXP = DISTRIBUTION_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Enumerated Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 2;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION___EVALUATE = DISTRIBUTION___EVALUATE;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION___GET_MODE_DISTRIBUTION = DISTRIBUTION___GET_MODE_DISTRIBUTION;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = DISTRIBUTION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Enumerated Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATED_DISTRIBUTION_OPERATION_COUNT = DISTRIBUTION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link distributions.impl.GammaDistributionImpl <em>Gamma Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.impl.GammaDistributionImpl
     * @see distributions.impl.DistributionsPackageImpl#getGammaDistribution()
     * @generated
     */
    int GAMMA_DISTRIBUTION = 5;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__NAME = DISTRIBUTION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__DEFAULT = DISTRIBUTION__DEFAULT;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__DEFAULT_EXP = DISTRIBUTION__DEFAULT_EXP;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE;

    /**
     * The feature id for the '<em><b>Shape</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__SHAPE = DISTRIBUTION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Scale</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__SCALE = DISTRIBUTION_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Inverse Cum Accuracy</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY = DISTRIBUTION_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Shape Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__SHAPE_EXP = DISTRIBUTION_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Scale Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__SCALE_EXP = DISTRIBUTION_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Inverse Cum Accuracy Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP = DISTRIBUTION_FEATURE_COUNT + 5;

    /**
     * The number of structural features of the '<em>Gamma Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 6;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION___EVALUATE = DISTRIBUTION___EVALUATE;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION___GET_MODE_DISTRIBUTION = DISTRIBUTION___GET_MODE_DISTRIBUTION;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = DISTRIBUTION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Gamma Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GAMMA_DISTRIBUTION_OPERATION_COUNT = DISTRIBUTION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link distributions.impl.PoissonDistributionImpl <em>Poisson Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.impl.PoissonDistributionImpl
     * @see distributions.impl.DistributionsPackageImpl#getPoissonDistribution()
     * @generated
     */
    int POISSON_DISTRIBUTION = 6;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__NAME = DISTRIBUTION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__DEFAULT = DISTRIBUTION__DEFAULT;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__DEFAULT_EXP = DISTRIBUTION__DEFAULT_EXP;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE;

    /**
     * The feature id for the '<em><b>P</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__P = DISTRIBUTION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Epsilon</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__EPSILON = DISTRIBUTION_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>PExp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__PEXP = DISTRIBUTION_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Epsilon Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION__EPSILON_EXP = DISTRIBUTION_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Poisson Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 4;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION___EVALUATE = DISTRIBUTION___EVALUATE;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION___GET_MODE_DISTRIBUTION = DISTRIBUTION___GET_MODE_DISTRIBUTION;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = DISTRIBUTION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Poisson Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POISSON_DISTRIBUTION_OPERATION_COUNT = DISTRIBUTION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link distributions.impl.LogNormalDistributionImpl <em>Log Normal Distribution</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.impl.LogNormalDistributionImpl
     * @see distributions.impl.DistributionsPackageImpl#getLogNormalDistribution()
     * @generated
     */
    int LOG_NORMAL_DISTRIBUTION = 7;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__NAME = DISTRIBUTION__NAME;

    /**
     * The feature id for the '<em><b>Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__DEFAULT = DISTRIBUTION__DEFAULT;

    /**
     * The feature id for the '<em><b>Default Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__DEFAULT_EXP = DISTRIBUTION__DEFAULT_EXP;

    /**
     * The feature id for the '<em><b>Mode Distribution Instance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE;

    /**
     * The feature id for the '<em><b>Shape</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__SHAPE = DISTRIBUTION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Scale</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__SCALE = DISTRIBUTION_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Inverse Cum Accuracy</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__INVERSE_CUM_ACCURACY = DISTRIBUTION_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Shape Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__SHAPE_EXP = DISTRIBUTION_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Scale Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__SCALE_EXP = DISTRIBUTION_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Inverse Cum Accuracy Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP = DISTRIBUTION_FEATURE_COUNT + 5;

    /**
     * The number of structural features of the '<em>Log Normal Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION_FEATURE_COUNT = DISTRIBUTION_FEATURE_COUNT + 6;

    /**
     * The operation id for the '<em>Evaluate</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION___EVALUATE = DISTRIBUTION___EVALUATE;

    /**
     * The operation id for the '<em>Get Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION___GET_MODE_DISTRIBUTION = DISTRIBUTION___GET_MODE_DISTRIBUTION;

    /**
     * The operation id for the '<em>Create Mode Distribution</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = DISTRIBUTION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Log Normal Distribution</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOG_NORMAL_DISTRIBUTION_OPERATION_COUNT = DISTRIBUTION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link distributions.CalculationMode <em>Calculation Mode</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.CalculationMode
     * @see distributions.impl.DistributionsPackageImpl#getCalculationMode()
     * @generated
     */
    int CALCULATION_MODE = 8;

    /**
     * The meta object id for the '<em>Random Generator</em>' data type.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.apache.commons.math3.random.RandomGenerator
     * @see distributions.impl.DistributionsPackageImpl#getRandomGenerator()
     * @generated
     */
    int RANDOM_GENERATOR = 9;

    /**
     * The meta object id for the '<em>Mode Distribution</em>' data type.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see distributions.math.ModeDistribution
     * @see distributions.impl.DistributionsPackageImpl#getModeDistribution()
     * @generated
     */
    int MODE_DISTRIBUTION = 10;


    /**
     * Returns the meta object for class '{@link distributions.Distribution <em>Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Distribution</em>'.
     * @see distributions.Distribution
     * @generated
     */
    EClass getDistribution();

    /**
     * Returns the meta object for the attribute '{@link distributions.Distribution#getDefault <em>Default</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Default</em>'.
     * @see distributions.Distribution#getDefault()
     * @see #getDistribution()
     * @generated
     */
    EAttribute getDistribution_Default();

    /**
     * Returns the meta object for the containment reference '{@link distributions.Distribution#getDefaultExp <em>Default Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Default Exp</em>'.
     * @see distributions.Distribution#getDefaultExp()
     * @see #getDistribution()
     * @generated
     */
    EReference getDistribution_DefaultExp();

    /**
     * Returns the meta object for the attribute '{@link distributions.Distribution#getModeDistributionInstance <em>Mode Distribution Instance</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Mode Distribution Instance</em>'.
     * @see distributions.Distribution#getModeDistributionInstance()
     * @see #getDistribution()
     * @generated
     */
    EAttribute getDistribution_ModeDistributionInstance();

    /**
     * Returns the meta object for the '{@link distributions.Distribution#evaluate() <em>Evaluate</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Evaluate</em>' operation.
     * @see distributions.Distribution#evaluate()
     * @generated
     */
    EOperation getDistribution__Evaluate();

    /**
     * Returns the meta object for the '{@link distributions.Distribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.Distribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for the '{@link distributions.Distribution#getModeDistribution() <em>Get Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Get Mode Distribution</em>' operation.
     * @see distributions.Distribution#getModeDistribution()
     * @generated
     */
    EOperation getDistribution__GetModeDistribution();

    /**
     * Returns the meta object for class '{@link distributions.TriangularDistribution <em>Triangular Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Triangular Distribution</em>'.
     * @see distributions.TriangularDistribution
     * @generated
     */
    EClass getTriangularDistribution();

    /**
     * Returns the meta object for the attribute '{@link distributions.TriangularDistribution#getMode <em>Mode</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Mode</em>'.
     * @see distributions.TriangularDistribution#getMode()
     * @see #getTriangularDistribution()
     * @generated
     */
    EAttribute getTriangularDistribution_Mode();

    /**
     * Returns the meta object for the attribute '{@link distributions.TriangularDistribution#getMin <em>Min</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Min</em>'.
     * @see distributions.TriangularDistribution#getMin()
     * @see #getTriangularDistribution()
     * @generated
     */
    EAttribute getTriangularDistribution_Min();

    /**
     * Returns the meta object for the attribute '{@link distributions.TriangularDistribution#getMax <em>Max</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Max</em>'.
     * @see distributions.TriangularDistribution#getMax()
     * @see #getTriangularDistribution()
     * @generated
     */
    EAttribute getTriangularDistribution_Max();

    /**
     * Returns the meta object for the containment reference '{@link distributions.TriangularDistribution#getModeExp <em>Mode Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Mode Exp</em>'.
     * @see distributions.TriangularDistribution#getModeExp()
     * @see #getTriangularDistribution()
     * @generated
     */
    EReference getTriangularDistribution_ModeExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.TriangularDistribution#getMinExp <em>Min Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Min Exp</em>'.
     * @see distributions.TriangularDistribution#getMinExp()
     * @see #getTriangularDistribution()
     * @generated
     */
    EReference getTriangularDistribution_MinExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.TriangularDistribution#getMaxExp <em>Max Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Max Exp</em>'.
     * @see distributions.TriangularDistribution#getMaxExp()
     * @see #getTriangularDistribution()
     * @generated
     */
    EReference getTriangularDistribution_MaxExp();

    /**
     * Returns the meta object for the '{@link distributions.TriangularDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.TriangularDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getTriangularDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for class '{@link distributions.PertDistribution <em>Pert Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Pert Distribution</em>'.
     * @see distributions.PertDistribution
     * @generated
     */
    EClass getPertDistribution();

    /**
     * Returns the meta object for the attribute '{@link distributions.PertDistribution#getMode <em>Mode</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Mode</em>'.
     * @see distributions.PertDistribution#getMode()
     * @see #getPertDistribution()
     * @generated
     */
    EAttribute getPertDistribution_Mode();

    /**
     * Returns the meta object for the attribute '{@link distributions.PertDistribution#getMin <em>Min</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Min</em>'.
     * @see distributions.PertDistribution#getMin()
     * @see #getPertDistribution()
     * @generated
     */
    EAttribute getPertDistribution_Min();

    /**
     * Returns the meta object for the attribute '{@link distributions.PertDistribution#getMax <em>Max</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Max</em>'.
     * @see distributions.PertDistribution#getMax()
     * @see #getPertDistribution()
     * @generated
     */
    EAttribute getPertDistribution_Max();

    /**
     * Returns the meta object for the containment reference '{@link distributions.PertDistribution#getModeExp <em>Mode Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Mode Exp</em>'.
     * @see distributions.PertDistribution#getModeExp()
     * @see #getPertDistribution()
     * @generated
     */
    EReference getPertDistribution_ModeExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.PertDistribution#getMinExp <em>Min Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Min Exp</em>'.
     * @see distributions.PertDistribution#getMinExp()
     * @see #getPertDistribution()
     * @generated
     */
    EReference getPertDistribution_MinExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.PertDistribution#getMaxExp <em>Max Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Max Exp</em>'.
     * @see distributions.PertDistribution#getMaxExp()
     * @see #getPertDistribution()
     * @generated
     */
    EReference getPertDistribution_MaxExp();

    /**
     * Returns the meta object for the attribute '{@link distributions.PertDistribution#getGamma <em>Gamma</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Gamma</em>'.
     * @see distributions.PertDistribution#getGamma()
     * @see #getPertDistribution()
     * @generated
     */
    EAttribute getPertDistribution_Gamma();

    /**
     * Returns the meta object for the containment reference '{@link distributions.PertDistribution#getGammaExp <em>Gamma Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Gamma Exp</em>'.
     * @see distributions.PertDistribution#getGammaExp()
     * @see #getPertDistribution()
     * @generated
     */
    EReference getPertDistribution_GammaExp();

    /**
     * Returns the meta object for the '{@link distributions.PertDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.PertDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getPertDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for class '{@link distributions.NormalDistribution <em>Normal Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Normal Distribution</em>'.
     * @see distributions.NormalDistribution
     * @generated
     */
    EClass getNormalDistribution();

    /**
     * Returns the meta object for the attribute '{@link distributions.NormalDistribution#getMean <em>Mean</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Mean</em>'.
     * @see distributions.NormalDistribution#getMean()
     * @see #getNormalDistribution()
     * @generated
     */
    EAttribute getNormalDistribution_Mean();

    /**
     * Returns the meta object for the attribute '{@link distributions.NormalDistribution#getSd <em>Sd</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Sd</em>'.
     * @see distributions.NormalDistribution#getSd()
     * @see #getNormalDistribution()
     * @generated
     */
    EAttribute getNormalDistribution_Sd();

    /**
     * Returns the meta object for the containment reference '{@link distributions.NormalDistribution#getMeanExp <em>Mean Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Mean Exp</em>'.
     * @see distributions.NormalDistribution#getMeanExp()
     * @see #getNormalDistribution()
     * @generated
     */
    EReference getNormalDistribution_MeanExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.NormalDistribution#getSdExp <em>Sd Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Sd Exp</em>'.
     * @see distributions.NormalDistribution#getSdExp()
     * @see #getNormalDistribution()
     * @generated
     */
    EReference getNormalDistribution_SdExp();

    /**
     * Returns the meta object for the '{@link distributions.NormalDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.NormalDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getNormalDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for class '{@link distributions.EnumeratedDistribution <em>Enumerated Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Enumerated Distribution</em>'.
     * @see distributions.EnumeratedDistribution
     * @generated
     */
    EClass getEnumeratedDistribution();

    /**
     * Returns the meta object for the attribute list '{@link distributions.EnumeratedDistribution#getValues <em>Values</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute list '<em>Values</em>'.
     * @see distributions.EnumeratedDistribution#getValues()
     * @see #getEnumeratedDistribution()
     * @generated
     */
    EAttribute getEnumeratedDistribution_Values();

    /**
     * Returns the meta object for the containment reference list '{@link distributions.EnumeratedDistribution#getValuesExp <em>Values Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Values Exp</em>'.
     * @see distributions.EnumeratedDistribution#getValuesExp()
     * @see #getEnumeratedDistribution()
     * @generated
     */
    EReference getEnumeratedDistribution_ValuesExp();

    /**
     * Returns the meta object for the '{@link distributions.EnumeratedDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.EnumeratedDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getEnumeratedDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for class '{@link distributions.GammaDistribution <em>Gamma Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Gamma Distribution</em>'.
     * @see distributions.GammaDistribution
     * @generated
     */
    EClass getGammaDistribution();

    /**
     * Returns the meta object for the attribute '{@link distributions.GammaDistribution#getShape <em>Shape</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Shape</em>'.
     * @see distributions.GammaDistribution#getShape()
     * @see #getGammaDistribution()
     * @generated
     */
    EAttribute getGammaDistribution_Shape();

    /**
     * Returns the meta object for the attribute '{@link distributions.GammaDistribution#getScale <em>Scale</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Scale</em>'.
     * @see distributions.GammaDistribution#getScale()
     * @see #getGammaDistribution()
     * @generated
     */
    EAttribute getGammaDistribution_Scale();

    /**
     * Returns the meta object for the attribute '{@link distributions.GammaDistribution#getInverseCumAccuracy <em>Inverse Cum Accuracy</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Inverse Cum Accuracy</em>'.
     * @see distributions.GammaDistribution#getInverseCumAccuracy()
     * @see #getGammaDistribution()
     * @generated
     */
    EAttribute getGammaDistribution_InverseCumAccuracy();

    /**
     * Returns the meta object for the containment reference '{@link distributions.GammaDistribution#getShapeExp <em>Shape Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Shape Exp</em>'.
     * @see distributions.GammaDistribution#getShapeExp()
     * @see #getGammaDistribution()
     * @generated
     */
    EReference getGammaDistribution_ShapeExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.GammaDistribution#getScaleExp <em>Scale Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Scale Exp</em>'.
     * @see distributions.GammaDistribution#getScaleExp()
     * @see #getGammaDistribution()
     * @generated
     */
    EReference getGammaDistribution_ScaleExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.GammaDistribution#getInverseCumAccuracyExp <em>Inverse Cum Accuracy Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Inverse Cum Accuracy Exp</em>'.
     * @see distributions.GammaDistribution#getInverseCumAccuracyExp()
     * @see #getGammaDistribution()
     * @generated
     */
    EReference getGammaDistribution_InverseCumAccuracyExp();

    /**
     * Returns the meta object for the '{@link distributions.GammaDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.GammaDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getGammaDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for class '{@link distributions.PoissonDistribution <em>Poisson Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Poisson Distribution</em>'.
     * @see distributions.PoissonDistribution
     * @generated
     */
    EClass getPoissonDistribution();

    /**
     * Returns the meta object for the attribute '{@link distributions.PoissonDistribution#getP <em>P</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>P</em>'.
     * @see distributions.PoissonDistribution#getP()
     * @see #getPoissonDistribution()
     * @generated
     */
    EAttribute getPoissonDistribution_P();

    /**
     * Returns the meta object for the attribute '{@link distributions.PoissonDistribution#getEpsilon <em>Epsilon</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Epsilon</em>'.
     * @see distributions.PoissonDistribution#getEpsilon()
     * @see #getPoissonDistribution()
     * @generated
     */
    EAttribute getPoissonDistribution_Epsilon();

    /**
     * Returns the meta object for the containment reference '{@link distributions.PoissonDistribution#getPExp <em>PExp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>PExp</em>'.
     * @see distributions.PoissonDistribution#getPExp()
     * @see #getPoissonDistribution()
     * @generated
     */
    EReference getPoissonDistribution_PExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.PoissonDistribution#getEpsilonExp <em>Epsilon Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Epsilon Exp</em>'.
     * @see distributions.PoissonDistribution#getEpsilonExp()
     * @see #getPoissonDistribution()
     * @generated
     */
    EReference getPoissonDistribution_EpsilonExp();

    /**
     * Returns the meta object for the '{@link distributions.PoissonDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.PoissonDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getPoissonDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for class '{@link distributions.LogNormalDistribution <em>Log Normal Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Log Normal Distribution</em>'.
     * @see distributions.LogNormalDistribution
     * @generated
     */
    EClass getLogNormalDistribution();

    /**
     * Returns the meta object for the attribute '{@link distributions.LogNormalDistribution#getShape <em>Shape</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Shape</em>'.
     * @see distributions.LogNormalDistribution#getShape()
     * @see #getLogNormalDistribution()
     * @generated
     */
    EAttribute getLogNormalDistribution_Shape();

    /**
     * Returns the meta object for the attribute '{@link distributions.LogNormalDistribution#getScale <em>Scale</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Scale</em>'.
     * @see distributions.LogNormalDistribution#getScale()
     * @see #getLogNormalDistribution()
     * @generated
     */
    EAttribute getLogNormalDistribution_Scale();

    /**
     * Returns the meta object for the attribute '{@link distributions.LogNormalDistribution#getInverseCumAccuracy <em>Inverse Cum Accuracy</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Inverse Cum Accuracy</em>'.
     * @see distributions.LogNormalDistribution#getInverseCumAccuracy()
     * @see #getLogNormalDistribution()
     * @generated
     */
    EAttribute getLogNormalDistribution_InverseCumAccuracy();

    /**
     * Returns the meta object for the containment reference '{@link distributions.LogNormalDistribution#getShapeExp <em>Shape Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Shape Exp</em>'.
     * @see distributions.LogNormalDistribution#getShapeExp()
     * @see #getLogNormalDistribution()
     * @generated
     */
    EReference getLogNormalDistribution_ShapeExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.LogNormalDistribution#getScaleExp <em>Scale Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Scale Exp</em>'.
     * @see distributions.LogNormalDistribution#getScaleExp()
     * @see #getLogNormalDistribution()
     * @generated
     */
    EReference getLogNormalDistribution_ScaleExp();

    /**
     * Returns the meta object for the containment reference '{@link distributions.LogNormalDistribution#getInverseCumAccuracyExp <em>Inverse Cum Accuracy Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Inverse Cum Accuracy Exp</em>'.
     * @see distributions.LogNormalDistribution#getInverseCumAccuracyExp()
     * @see #getLogNormalDistribution()
     * @generated
     */
    EReference getLogNormalDistribution_InverseCumAccuracyExp();

    /**
     * Returns the meta object for the '{@link distributions.LogNormalDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator) <em>Create Mode Distribution</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Create Mode Distribution</em>' operation.
     * @see distributions.LogNormalDistribution#createModeDistribution(org.apache.commons.math3.random.RandomGenerator)
     * @generated
     */
    EOperation getLogNormalDistribution__CreateModeDistribution__RandomGenerator();

    /**
     * Returns the meta object for enum '{@link distributions.CalculationMode <em>Calculation Mode</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for enum '<em>Calculation Mode</em>'.
     * @see distributions.CalculationMode
     * @generated
     */
    EEnum getCalculationMode();

    /**
     * Returns the meta object for data type '{@link org.apache.commons.math3.random.RandomGenerator <em>Random Generator</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for data type '<em>Random Generator</em>'.
     * @see org.apache.commons.math3.random.RandomGenerator
     * @model instanceClass="org.apache.commons.math3.random.RandomGenerator"
     * @generated
     */
    EDataType getRandomGenerator();

    /**
     * Returns the meta object for data type '{@link distributions.math.ModeDistribution <em>Mode Distribution</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for data type '<em>Mode Distribution</em>'.
     * @see distributions.math.ModeDistribution
     * @model instanceClass="distributions.math.ModeDistribution"
     * @generated
     */
    EDataType getModeDistribution();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
    DistributionsFactory getDistributionsFactory();

    /**
     * <!-- begin-user-doc -->
     * Defines literals for the meta objects that represent
     * <ul>
     *   <li>each class,</li>
     *   <li>each feature of each class,</li>
     *   <li>each operation of each class,</li>
     *   <li>each enum,</li>
     *   <li>and each data type</li>
     * </ul>
     * <!-- end-user-doc -->
     * @generated
     */
    interface Literals
    {
        /**
         * The meta object literal for the '{@link distributions.Distribution <em>Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.Distribution
         * @see distributions.impl.DistributionsPackageImpl#getDistribution()
         * @generated
         */
        EClass DISTRIBUTION = eINSTANCE.getDistribution();

        /**
         * The meta object literal for the '<em><b>Default</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute DISTRIBUTION__DEFAULT = eINSTANCE.getDistribution_Default();

        /**
         * The meta object literal for the '<em><b>Default Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference DISTRIBUTION__DEFAULT_EXP = eINSTANCE.getDistribution_DefaultExp();

        /**
         * The meta object literal for the '<em><b>Mode Distribution Instance</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE = eINSTANCE.getDistribution_ModeDistributionInstance();

        /**
         * The meta object literal for the '<em><b>Evaluate</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation DISTRIBUTION___EVALUATE = eINSTANCE.getDistribution__Evaluate();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '<em><b>Get Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation DISTRIBUTION___GET_MODE_DISTRIBUTION = eINSTANCE.getDistribution__GetModeDistribution();

        /**
         * The meta object literal for the '{@link distributions.impl.TriangularDistributionImpl <em>Triangular Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.impl.TriangularDistributionImpl
         * @see distributions.impl.DistributionsPackageImpl#getTriangularDistribution()
         * @generated
         */
        EClass TRIANGULAR_DISTRIBUTION = eINSTANCE.getTriangularDistribution();

        /**
         * The meta object literal for the '<em><b>Mode</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TRIANGULAR_DISTRIBUTION__MODE = eINSTANCE.getTriangularDistribution_Mode();

        /**
         * The meta object literal for the '<em><b>Min</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TRIANGULAR_DISTRIBUTION__MIN = eINSTANCE.getTriangularDistribution_Min();

        /**
         * The meta object literal for the '<em><b>Max</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TRIANGULAR_DISTRIBUTION__MAX = eINSTANCE.getTriangularDistribution_Max();

        /**
         * The meta object literal for the '<em><b>Mode Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference TRIANGULAR_DISTRIBUTION__MODE_EXP = eINSTANCE.getTriangularDistribution_ModeExp();

        /**
         * The meta object literal for the '<em><b>Min Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference TRIANGULAR_DISTRIBUTION__MIN_EXP = eINSTANCE.getTriangularDistribution_MinExp();

        /**
         * The meta object literal for the '<em><b>Max Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference TRIANGULAR_DISTRIBUTION__MAX_EXP = eINSTANCE.getTriangularDistribution_MaxExp();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation TRIANGULAR_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getTriangularDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '{@link distributions.impl.PertDistributionImpl <em>Pert Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.impl.PertDistributionImpl
         * @see distributions.impl.DistributionsPackageImpl#getPertDistribution()
         * @generated
         */
        EClass PERT_DISTRIBUTION = eINSTANCE.getPertDistribution();

        /**
         * The meta object literal for the '<em><b>Mode</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute PERT_DISTRIBUTION__MODE = eINSTANCE.getPertDistribution_Mode();

        /**
         * The meta object literal for the '<em><b>Min</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute PERT_DISTRIBUTION__MIN = eINSTANCE.getPertDistribution_Min();

        /**
         * The meta object literal for the '<em><b>Max</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute PERT_DISTRIBUTION__MAX = eINSTANCE.getPertDistribution_Max();

        /**
         * The meta object literal for the '<em><b>Mode Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference PERT_DISTRIBUTION__MODE_EXP = eINSTANCE.getPertDistribution_ModeExp();

        /**
         * The meta object literal for the '<em><b>Min Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference PERT_DISTRIBUTION__MIN_EXP = eINSTANCE.getPertDistribution_MinExp();

        /**
         * The meta object literal for the '<em><b>Max Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference PERT_DISTRIBUTION__MAX_EXP = eINSTANCE.getPertDistribution_MaxExp();

        /**
         * The meta object literal for the '<em><b>Gamma</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute PERT_DISTRIBUTION__GAMMA = eINSTANCE.getPertDistribution_Gamma();

        /**
         * The meta object literal for the '<em><b>Gamma Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference PERT_DISTRIBUTION__GAMMA_EXP = eINSTANCE.getPertDistribution_GammaExp();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation PERT_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getPertDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '{@link distributions.impl.NormalDistributionImpl <em>Normal Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.impl.NormalDistributionImpl
         * @see distributions.impl.DistributionsPackageImpl#getNormalDistribution()
         * @generated
         */
        EClass NORMAL_DISTRIBUTION = eINSTANCE.getNormalDistribution();

        /**
         * The meta object literal for the '<em><b>Mean</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute NORMAL_DISTRIBUTION__MEAN = eINSTANCE.getNormalDistribution_Mean();

        /**
         * The meta object literal for the '<em><b>Sd</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute NORMAL_DISTRIBUTION__SD = eINSTANCE.getNormalDistribution_Sd();

        /**
         * The meta object literal for the '<em><b>Mean Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference NORMAL_DISTRIBUTION__MEAN_EXP = eINSTANCE.getNormalDistribution_MeanExp();

        /**
         * The meta object literal for the '<em><b>Sd Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference NORMAL_DISTRIBUTION__SD_EXP = eINSTANCE.getNormalDistribution_SdExp();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation NORMAL_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getNormalDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '{@link distributions.impl.EnumeratedDistributionImpl <em>Enumerated Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.impl.EnumeratedDistributionImpl
         * @see distributions.impl.DistributionsPackageImpl#getEnumeratedDistribution()
         * @generated
         */
        EClass ENUMERATED_DISTRIBUTION = eINSTANCE.getEnumeratedDistribution();

        /**
         * The meta object literal for the '<em><b>Values</b></em>' attribute list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute ENUMERATED_DISTRIBUTION__VALUES = eINSTANCE.getEnumeratedDistribution_Values();

        /**
         * The meta object literal for the '<em><b>Values Exp</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference ENUMERATED_DISTRIBUTION__VALUES_EXP = eINSTANCE.getEnumeratedDistribution_ValuesExp();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation ENUMERATED_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getEnumeratedDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '{@link distributions.impl.GammaDistributionImpl <em>Gamma Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.impl.GammaDistributionImpl
         * @see distributions.impl.DistributionsPackageImpl#getGammaDistribution()
         * @generated
         */
        EClass GAMMA_DISTRIBUTION = eINSTANCE.getGammaDistribution();

        /**
         * The meta object literal for the '<em><b>Shape</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute GAMMA_DISTRIBUTION__SHAPE = eINSTANCE.getGammaDistribution_Shape();

        /**
         * The meta object literal for the '<em><b>Scale</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute GAMMA_DISTRIBUTION__SCALE = eINSTANCE.getGammaDistribution_Scale();

        /**
         * The meta object literal for the '<em><b>Inverse Cum Accuracy</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY = eINSTANCE.getGammaDistribution_InverseCumAccuracy();

        /**
         * The meta object literal for the '<em><b>Shape Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference GAMMA_DISTRIBUTION__SHAPE_EXP = eINSTANCE.getGammaDistribution_ShapeExp();

        /**
         * The meta object literal for the '<em><b>Scale Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference GAMMA_DISTRIBUTION__SCALE_EXP = eINSTANCE.getGammaDistribution_ScaleExp();

        /**
         * The meta object literal for the '<em><b>Inverse Cum Accuracy Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP = eINSTANCE.getGammaDistribution_InverseCumAccuracyExp();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation GAMMA_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getGammaDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '{@link distributions.impl.PoissonDistributionImpl <em>Poisson Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.impl.PoissonDistributionImpl
         * @see distributions.impl.DistributionsPackageImpl#getPoissonDistribution()
         * @generated
         */
        EClass POISSON_DISTRIBUTION = eINSTANCE.getPoissonDistribution();

        /**
         * The meta object literal for the '<em><b>P</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute POISSON_DISTRIBUTION__P = eINSTANCE.getPoissonDistribution_P();

        /**
         * The meta object literal for the '<em><b>Epsilon</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute POISSON_DISTRIBUTION__EPSILON = eINSTANCE.getPoissonDistribution_Epsilon();

        /**
         * The meta object literal for the '<em><b>PExp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference POISSON_DISTRIBUTION__PEXP = eINSTANCE.getPoissonDistribution_PExp();

        /**
         * The meta object literal for the '<em><b>Epsilon Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference POISSON_DISTRIBUTION__EPSILON_EXP = eINSTANCE.getPoissonDistribution_EpsilonExp();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation POISSON_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getPoissonDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '{@link distributions.impl.LogNormalDistributionImpl <em>Log Normal Distribution</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.impl.LogNormalDistributionImpl
         * @see distributions.impl.DistributionsPackageImpl#getLogNormalDistribution()
         * @generated
         */
        EClass LOG_NORMAL_DISTRIBUTION = eINSTANCE.getLogNormalDistribution();

        /**
         * The meta object literal for the '<em><b>Shape</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute LOG_NORMAL_DISTRIBUTION__SHAPE = eINSTANCE.getLogNormalDistribution_Shape();

        /**
         * The meta object literal for the '<em><b>Scale</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute LOG_NORMAL_DISTRIBUTION__SCALE = eINSTANCE.getLogNormalDistribution_Scale();

        /**
         * The meta object literal for the '<em><b>Inverse Cum Accuracy</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute LOG_NORMAL_DISTRIBUTION__INVERSE_CUM_ACCURACY = eINSTANCE.getLogNormalDistribution_InverseCumAccuracy();

        /**
         * The meta object literal for the '<em><b>Shape Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference LOG_NORMAL_DISTRIBUTION__SHAPE_EXP = eINSTANCE.getLogNormalDistribution_ShapeExp();

        /**
         * The meta object literal for the '<em><b>Scale Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference LOG_NORMAL_DISTRIBUTION__SCALE_EXP = eINSTANCE.getLogNormalDistribution_ScaleExp();

        /**
         * The meta object literal for the '<em><b>Inverse Cum Accuracy Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference LOG_NORMAL_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP = eINSTANCE.getLogNormalDistribution_InverseCumAccuracyExp();

        /**
         * The meta object literal for the '<em><b>Create Mode Distribution</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation LOG_NORMAL_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR = eINSTANCE.getLogNormalDistribution__CreateModeDistribution__RandomGenerator();

        /**
         * The meta object literal for the '{@link distributions.CalculationMode <em>Calculation Mode</em>}' enum.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.CalculationMode
         * @see distributions.impl.DistributionsPackageImpl#getCalculationMode()
         * @generated
         */
        EEnum CALCULATION_MODE = eINSTANCE.getCalculationMode();

        /**
         * The meta object literal for the '<em>Random Generator</em>' data type.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see org.apache.commons.math3.random.RandomGenerator
         * @see distributions.impl.DistributionsPackageImpl#getRandomGenerator()
         * @generated
         */
        EDataType RANDOM_GENERATOR = eINSTANCE.getRandomGenerator();

        /**
         * The meta object literal for the '<em>Mode Distribution</em>' data type.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see distributions.math.ModeDistribution
         * @see distributions.impl.DistributionsPackageImpl#getModeDistribution()
         * @generated
         */
        EDataType MODE_DISTRIBUTION = eINSTANCE.getModeDistribution();

    }

} //DistributionsPackage
