/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.launch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    private int myCount = 0;
    private final Writer myWriter;
    private final ByteArrayOutputStream myByteArrayOutputStream = new ByteArrayOutputStream(8192);
    private static final int BUFFER_SIZE = 8192;

    public WriterOutputStream(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException();
        }
        this.myWriter = writer;
    }

    @Override
    public void write(int b) throws IOException {
        this.myByteArrayOutputStream.write(b);
        ++this.myCount;
        if (this.myCount == 8192) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.myCount == 0) {
            return;
        }
        try {
            this.myWriter.write(this.myByteArrayOutputStream.toString());
        }
        finally {
            this.myCount = 0;
            this.myByteArrayOutputStream.reset();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.myWriter.close();
        }
    }
}

