/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.internal.refresh.SynchronizeDDiagramElementStylePropertiesCommand;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ViewPropertiesSynchronizer;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;

public class FontFormatUpdater
extends ResourceSetListenerImpl {
    private static final NotificationFilter FEATURES_TO_REFACTOR_FILTER = NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Underline())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_StrikeThrough()))).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold()).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic())).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Underline())).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_StrikeThrough()))).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor()));

    public FontFormatUpdater(TransactionalEditingDomain domain) {
        super(FEATURES_TO_REFACTOR_FILTER);
        domain.addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        FontStyle fontStyle;
        CompoundCommand cc = new CompoundCommand();
        HashMap<FontStyle, HashSet<EStructuralFeature>> fontStyleFeatureChanges = new HashMap<FontStyle, HashSet<EStructuralFeature>>();
        for (Notification notification : event.getNotifications()) {
            if (!(notification.getNotifier() instanceof FontStyle) || !(notification.getFeature() instanceof EStructuralFeature)) continue;
            fontStyle = (FontStyle)notification.getNotifier();
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            HashSet<EStructuralFeature> featureChanges = (HashSet<EStructuralFeature>)fontStyleFeatureChanges.get(fontStyle);
            if (featureChanges == null) {
                featureChanges = new HashSet<EStructuralFeature>();
                fontStyleFeatureChanges.put(fontStyle, featureChanges);
            }
            featureChanges.add(feature);
        }
        for (Map.Entry entry : fontStyleFeatureChanges.entrySet()) {
            DDiagramElement dDiagramElement;
            org.eclipse.sirius.viewpoint.Style style;
            fontStyle = (FontStyle)entry.getKey();
            Set features = (Set)entry.getValue();
            View view = (View)fontStyle.eContainer();
            if (!(view.getElement() instanceof DDiagramElement) || features.isEmpty() || !this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)(style = (dDiagramElement = (DDiagramElement)view.getElement()).getStyle()), fontStyle, features)) continue;
            Set<String> featureNames = this.getFeatureNames(features);
            if (style instanceof EdgeStyle) {
                EdgeStyle edgeStyle = (EdgeStyle)style;
                String labelFormat = ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName();
                if (featureNames.contains(labelFormat)) {
                    BasicLabelStyleDescription description;
                    if (edgeStyle.getBeginLabelStyle() != null) {
                        description = edgeStyle.getBeginLabelStyle().getDescription();
                        if (!this.isSameLabelFormat(fontStyle, (EList<FontFormat>)description.getLabelFormat())) {
                            cc.append((Command)new AddLabelFormatAsCustomFeatureCommand(this.getTarget(), (BasicLabelStyle)edgeStyle.getBeginLabelStyle()));
                        } else {
                            cc.append((Command)new RemoveLabelFormatFromCustomFeatureCommand(this.getTarget(), (BasicLabelStyle)edgeStyle.getBeginLabelStyle()));
                        }
                    }
                    if (edgeStyle.getCenterLabelStyle() != null) {
                        description = edgeStyle.getCenterLabelStyle().getDescription();
                        if (!this.isSameLabelFormat(fontStyle, (EList<FontFormat>)description.getLabelFormat())) {
                            cc.append((Command)new AddLabelFormatAsCustomFeatureCommand(this.getTarget(), (BasicLabelStyle)edgeStyle.getCenterLabelStyle()));
                        } else {
                            cc.append((Command)new RemoveLabelFormatFromCustomFeatureCommand(this.getTarget(), (BasicLabelStyle)edgeStyle.getCenterLabelStyle()));
                        }
                    }
                    if (edgeStyle.getEndLabelStyle() != null) {
                        description = edgeStyle.getEndLabelStyle().getDescription();
                        if (!this.isSameLabelFormat(fontStyle, (EList<FontFormat>)description.getLabelFormat())) {
                            cc.append((Command)new AddLabelFormatAsCustomFeatureCommand(this.getTarget(), (BasicLabelStyle)edgeStyle.getEndLabelStyle()));
                        } else {
                            cc.append((Command)new RemoveLabelFormatFromCustomFeatureCommand(this.getTarget(), (BasicLabelStyle)edgeStyle.getEndLabelStyle()));
                        }
                    }
                }
            } else {
                featureNames.addAll((Collection<String>)style.getCustomFeatures());
                Command addCustomFeaturesCmd = SetCommand.create((EditingDomain)this.getTarget(), (Object)style, (Object)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, featureNames);
                cc.append(addCustomFeaturesCmd);
            }
            cc.append((Command)new SynchronizeDDiagramElementStylePropertiesCommand(this.getTarget(), view));
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private boolean isSameLabelFormat(FontStyle gmfStyle, EList<FontFormat> siriusStyle) {
        boolean sameStrike;
        boolean sameBold = gmfStyle.isBold() == siriusStyle.contains((Object)FontFormat.BOLD_LITERAL);
        boolean sameItalic = gmfStyle.isItalic() == siriusStyle.contains((Object)FontFormat.ITALIC_LITERAL);
        boolean sameUnderline = gmfStyle.isUnderline() == siriusStyle.contains((Object)FontFormat.UNDERLINE_LITERAL);
        boolean bl = sameStrike = gmfStyle.isStrikeThrough() == siriusStyle.contains((Object)FontFormat.STRIKE_THROUGH_LITERAL);
        return sameBold && sameItalic && sameUnderline && sameStrike;
    }

    private boolean isViewFontStylePropertiesDifferentOfGMFOne(Customizable viewpointStyle, FontStyle gmfFontStyle, Set<EStructuralFeature> gmfStyleFeatures) {
        boolean isViewFontStylePropertiesDifferentOfGMFOne;
        block4: {
            block3: {
                isViewFontStylePropertiesDifferentOfGMFOne = false;
                if (!(viewpointStyle instanceof EdgeStyle)) break block3;
                EdgeStyle edgeStyle = (EdgeStyle)viewpointStyle;
                if (edgeStyle.getBeginLabelStyle() != null) {
                    isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getBeginLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                }
                if (!isViewFontStylePropertiesDifferentOfGMFOne && edgeStyle.getCenterLabelStyle() != null) {
                    isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getCenterLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                }
                if (isViewFontStylePropertiesDifferentOfGMFOne || edgeStyle.getEndLabelStyle() == null) break block4;
                isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getEndLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                break block4;
            }
            for (EStructuralFeature gmfStyleFeature : gmfStyleFeatures) {
                EStructuralFeature viewpointStyleFeature = ViewPropertiesSynchronizer.GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.get(gmfStyleFeature);
                if (!(viewpointStyleFeature instanceof EAttribute) || !viewpointStyle.eClass().getEAllStructuralFeatures().contains((Object)viewpointStyleFeature)) continue;
                Object viewpointStyleProperty = viewpointStyle.eGet(viewpointStyleFeature);
                Object gmfStyleProperty = this.convertToSiriusPropertyValue((Style)gmfFontStyle, gmfStyleFeature);
                if (viewpointStyleProperty == null || viewpointStyleProperty.equals(gmfStyleProperty)) continue;
                isViewFontStylePropertiesDifferentOfGMFOne = true;
                break;
            }
        }
        return isViewFontStylePropertiesDifferentOfGMFOne;
    }

    private Object convertToSiriusPropertyValue(Style gmfStyle, EStructuralFeature gmfStyleAttribute) {
        RGBValues gmfStylePropertyValue = gmfStyle.eGet(gmfStyleAttribute);
        if (gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__BOLD || gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__ITALIC || gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__UNDERLINE || gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__STRIKE_THROUGH) {
            FontStyle gmfFontStyle = (FontStyle)gmfStyle;
            gmfStylePropertyValue = new ArrayList();
            if (gmfFontStyle.isBold()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.BOLD_LITERAL);
            }
            if (gmfFontStyle.isItalic()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.ITALIC_LITERAL);
            }
            if (gmfFontStyle.isUnderline()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.UNDERLINE_LITERAL);
            }
            if (gmfFontStyle.isStrikeThrough()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.STRIKE_THROUGH_LITERAL);
            }
            if (!(gmfFontStyle.isBold() || gmfFontStyle.isItalic() || gmfFontStyle.isUnderline() || gmfFontStyle.isStrikeThrough())) {
                ((List)gmfStylePropertyValue).clear();
            }
        } else if (gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__FONT_COLOR) {
            FontStyle gmfFontStyle = (FontStyle)gmfStyle;
            gmfStylePropertyValue = RGBValues.integerToRGBValues((int)gmfFontStyle.getFontColor());
        }
        return gmfStylePropertyValue;
    }

    private Set<String> getFeatureNames(Set<EStructuralFeature> features) {
        LinkedHashSet<String> featureNames = new LinkedHashSet<String>();
        for (EStructuralFeature feature : features) {
            EStructuralFeature eStructuralFeature;
            String featureName = feature.getName();
            if (this.isFeatureOfNotationPackage(feature) && (eStructuralFeature = ViewPropertiesSynchronizer.GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.get(feature)) != null) {
                featureName = eStructuralFeature.getName();
            }
            featureNames.add(featureName);
        }
        return featureNames;
    }

    private boolean isFeatureOfNotationPackage(EStructuralFeature feature) {
        boolean isFeatureOfNotationPackage = false;
        isFeatureOfNotationPackage = feature.getEContainingClass().getEPackage() == NotationPackage.eINSTANCE;
        return isFeatureOfNotationPackage;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }

    class AddLabelFormatAsCustomFeatureCommand
    extends RecordingCommand {
        BasicLabelStyle style;

        public AddLabelFormatAsCustomFeatureCommand(TransactionalEditingDomain domain, BasicLabelStyle style) {
            super(domain);
            this.style = style;
        }

        protected void doExecute() {
            String labelFormat = ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName();
            this.style.getCustomFeatures().add((Object)labelFormat);
        }
    }

    class RemoveLabelFormatFromCustomFeatureCommand
    extends RecordingCommand {
        BasicLabelStyle style;

        public RemoveLabelFormatFromCustomFeatureCommand(TransactionalEditingDomain domain, BasicLabelStyle style) {
            super(domain);
            this.style = style;
        }

        protected void doExecute() {
            String labelFormat = ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName();
            this.style.getCustomFeatures().remove((Object)labelFormat);
        }
    }
}

