/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ClassFileCache {
    private static final Object NULL = new Object();
    private final Map<QualifiedName, Object> cache = new ConcurrentHashMap<QualifiedName, Object>();
    private final Set<Resource> resourcesToCompile = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<char[], List<String>> allTopLevelTypes = new ConcurrentHashMap<char[], List<String>>();
    private final Map<char[], Map<String, byte[]>> allClassMaps = new ConcurrentHashMap<char[], Map<String, byte[]>>();

    public boolean containsKey(QualifiedName qualifiedName) {
        return this.cache.containsKey(qualifiedName);
    }

    public IBinaryType get(QualifiedName qualifiedName) {
        Object result = this.cache.get(qualifiedName);
        if (result == NULL) {
            return null;
        }
        return (IBinaryType)result;
    }

    public void put(QualifiedName qualifiedName, IBinaryType answer) {
        if (answer == null) {
            this.cache.put(qualifiedName, NULL);
        } else {
            this.cache.put(qualifiedName, answer);
        }
    }

    public IBinaryType computeIfAbsent(QualifiedName qualifiedName, Function<? super QualifiedName, ? extends IBinaryType> fun) {
        Object result = this.cache.computeIfAbsent(qualifiedName, (? super K fqn) -> {
            IBinaryType binaryType = (IBinaryType)fun.apply((QualifiedName)fqn);
            if (binaryType != null) {
                return binaryType;
            }
            return NULL;
        });
        if (result instanceof IBinaryType) {
            return (IBinaryType)result;
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
        this.resourcesToCompile.clear();
        this.allTopLevelTypes.clear();
        this.allClassMaps.clear();
    }

    public void addResourceToCompile(Resource resource) {
        this.resourcesToCompile.add(resource);
    }

    public Set<Resource> drainResourcesToCompile() {
        HashSet<Resource> result = new HashSet<Resource>(this.resourcesToCompile);
        this.resourcesToCompile.clear();
        return result;
    }

    public boolean popCompileResult(char[] fileName, Procedures.Procedure2<? super List<String>, ? super Map<String, byte[]>> consumer) {
        if (this.allTopLevelTypes.containsKey(fileName)) {
            consumer.apply(this.allTopLevelTypes.remove(fileName), this.allClassMaps.remove(fileName));
            return true;
        }
        return false;
    }

    public void addCompileResult(char[] fileName, List<String> topLevelTypes, Map<String, byte[]> classMap) {
        this.allTopLevelTypes.put(fileName, topLevelTypes);
        this.allClassMaps.put(fileName, classMap);
    }

    public static ClassFileCache findInEmfObject(Notifier emfObject) {
        ClassFileCacheAdapter adapter = (ClassFileCacheAdapter)EcoreUtil.getExistingAdapter((Notifier)emfObject, ClassFileCache.class);
        if (adapter != null) {
            return adapter.get();
        }
        return null;
    }

    public static ClassFileCache removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        int i = 0;
        int max = adapters.size();
        while (i < max) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter instanceof ClassFileCacheAdapter) {
                emfObject.eAdapters().remove(i);
                return ((ClassFileCacheAdapter)adapter).get();
            }
            ++i;
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        ClassFileCache result = ClassFileCache.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for ClassFileCache");
        }
        ClassFileCacheAdapter adapter = new ClassFileCacheAdapter(this);
        emfObject.eAdapters().add((Object)adapter);
    }

    public static class ClassFileCacheAdapter
    extends AdapterImpl {
        private ClassFileCache element;

        public ClassFileCacheAdapter(ClassFileCache element) {
            this.element = element;
        }

        public ClassFileCache get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == ClassFileCache.class;
        }
    }
}

