/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.ILayoutPhaseFactory;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.intermediate.NodePromotionStrategy;
import org.eclipse.elk.alg.layered.intermediate.compaction.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.p3order.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.p5edges.EdgeRouterFactory;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.GreedySwitchType;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.Spacings;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;

final class GraphConfigurator {
    private static final int INITIAL_CONFIGURATION_SIZE = 30;
    private static final IntermediateProcessingConfiguration BASELINE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.NODE_MARGIN_CALCULATOR).addBeforePhase4(IntermediateProcessorStrategy.LABEL_AND_NODE_SIZE_PROCESSOR).addBeforePhase5(IntermediateProcessorStrategy.LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR);
    private static final IntermediateProcessingConfiguration LABEL_MANAGEMENT_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.LABEL_MANAGEMENT_PROCESSOR);
    private final Map<Object, ILayoutPhase> phaseCache = Maps.newHashMap();
    private final Map<IntermediateProcessorStrategy, ILayoutProcessor> intermediateProcessorCache = Maps.newHashMap();
    private static final double MIN_EDGE_SPACING = 2.0;

    GraphConfigurator() {
    }

    private void configureGraphProperties(LGraph lgraph) {
        Integer randomSeed;
        Direction direction;
        double edgeSpacing = (Double)lgraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        if (edgeSpacing < 2.0) {
            lgraph.setProperty(LayeredOptions.SPACING_EDGE_EDGE, 2.0);
        }
        if ((direction = (Direction)lgraph.getProperty(LayeredOptions.DIRECTION)) == Direction.UNDEFINED) {
            lgraph.setProperty(LayeredOptions.DIRECTION, LGraphUtil.getDirection(lgraph));
        }
        if ((randomSeed = (Integer)lgraph.getProperty(LayeredOptions.RANDOM_SEED)) == 0) {
            lgraph.setProperty(InternalProperties.RANDOM, new Random());
        } else {
            lgraph.setProperty(InternalProperties.RANDOM, new Random(randomSeed.intValue()));
        }
        Boolean favorStraightness = (Boolean)lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES);
        if (favorStraightness == null) {
            lgraph.setProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES, lgraph.getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL);
        }
        Spacings spacings = new Spacings(lgraph);
        lgraph.setProperty(InternalProperties.SPACINGS, spacings);
    }

    public void prepareGraphForLayout(LGraph lgraph) {
        this.configureGraphProperties(lgraph);
        ILayoutPhase cycleBreaker = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY));
        ILayoutPhase layerer = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.LAYERING_STRATEGY));
        ILayoutPhase crossingMinimizer = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY));
        ILayoutPhase nodePlacer = this.cachedLayoutPhase((ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY));
        ILayoutPhase edgeRouter = this.cachedLayoutPhase(EdgeRouterFactory.factoryFor((EdgeRouting)lgraph.getProperty(LayeredOptions.EDGE_ROUTING)));
        IntermediateProcessingConfiguration intermediateProcessingConfiguration = IntermediateProcessingConfiguration.createEmpty();
        lgraph.setProperty(InternalProperties.CONFIGURATION, intermediateProcessingConfiguration);
        intermediateProcessingConfiguration.addAll(cycleBreaker.getIntermediateProcessingConfiguration(lgraph)).addAll(layerer.getIntermediateProcessingConfiguration(lgraph)).addAll(crossingMinimizer.getIntermediateProcessingConfiguration(lgraph)).addAll(nodePlacer.getIntermediateProcessingConfiguration(lgraph)).addAll(edgeRouter.getIntermediateProcessingConfiguration(lgraph)).addAll(this.getPhaseIndependentIntermediateProcessingConfiguration(lgraph));
        ArrayList algorithm = Lists.newArrayListWithCapacity((int)30);
        lgraph.setProperty(InternalProperties.PROCESSORS, algorithm);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_1));
        algorithm.add(cycleBreaker);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_2));
        algorithm.add(layerer);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_3));
        algorithm.add(crossingMinimizer);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_4));
        algorithm.add(nodePlacer);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.BEFORE_PHASE_5));
        algorithm.add(edgeRouter);
        algorithm.addAll(this.getIntermediateProcessorList(intermediateProcessingConfiguration, IntermediateProcessingConfiguration.Slot.AFTER_PHASE_5));
    }

    private ILayoutPhase cachedLayoutPhase(ILayoutPhaseFactory factory) {
        ILayoutPhase layoutPhase = this.phaseCache.get(factory);
        if (layoutPhase == null) {
            layoutPhase = factory.create();
            this.phaseCache.put(factory, layoutPhase);
        }
        return layoutPhase;
    }

    private List<ILayoutProcessor> getIntermediateProcessorList(IntermediateProcessingConfiguration configuration, IntermediateProcessingConfiguration.Slot slot) {
        Set<IntermediateProcessorStrategy> processors = configuration.getProcessors(slot);
        ArrayList<ILayoutProcessor> result = new ArrayList<ILayoutProcessor>(processors.size());
        for (IntermediateProcessorStrategy processor : processors) {
            ILayoutProcessor processorImpl = this.intermediateProcessorCache.get((Object)processor);
            if (processorImpl == null) {
                processorImpl = processor.create();
                this.intermediateProcessorCache.put(processor, processorImpl);
            }
            result.add(processorImpl);
        }
        return result;
    }

    private IntermediateProcessingConfiguration getPhaseIndependentIntermediateProcessingConfiguration(LGraph lgraph) {
        Set graphProperties = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.fromExisting(BASELINE_PROCESSING_CONFIGURATION);
        if (((Boolean)lgraph.getProperty(LayeredOptions.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addBeforePhase1(IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        } else {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        }
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) != null) {
            configuration.addAll(LABEL_MANAGEMENT_ADDITIONS);
        }
        switch ((Direction)lgraph.getProperty(LayeredOptions.DIRECTION)) {
            case LEFT: {
                configuration.addBeforePhase1(IntermediateProcessorStrategy.LEFT_DIR_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.LEFT_DIR_POSTPROCESSOR);
                break;
            }
            case DOWN: {
                configuration.addBeforePhase1(IntermediateProcessorStrategy.DOWN_DIR_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.DOWN_DIR_POSTPROCESSOR);
                break;
            }
            case UP: {
                configuration.addBeforePhase1(IntermediateProcessorStrategy.UP_DIR_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.UP_DIR_POSTPROCESSOR);
                break;
            }
        }
        if (graphProperties.contains((Object)GraphProperties.COMMENTS)) {
            configuration.addBeforePhase1(IntermediateProcessorStrategy.COMMENT_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.COMMENT_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_STRATEGY) != NodePromotionStrategy.NONE) {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.NODE_PROMOTION);
        }
        if (graphProperties.contains((Object)GraphProperties.PARTITIONS)) {
            configuration.addBeforePhase1(IntermediateProcessorStrategy.PARTITION_PREPROCESSOR);
            configuration.addBeforePhase3(IntermediateProcessorStrategy.PARTITION_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_STRATEGY) != GraphCompactionStrategy.NONE && lgraph.getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL) {
            configuration.addAfterPhase5(IntermediateProcessorStrategy.HORIZONTAL_COMPACTOR);
        }
        if (((Boolean)lgraph.getProperty(LayeredOptions.HIGH_DEGREE_NODES_TREATMENT)).booleanValue()) {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.HIGH_DEGREE_NODE_LAYER_PROCESSOR);
        }
        if (((Boolean)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_SEMI_INTERACTIVE)).booleanValue()) {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.SEMI_INTERACTIVE_CROSSMIN_PROCESSOR);
        }
        GreedySwitchType greedySwitchType = (GreedySwitchType)((Object)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE));
        boolean interactiveCrossMin = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY) == CrossingMinimizationStrategy.INTERACTIVE;
        int activationThreshold = (Integer)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_ACTIVATION_THRESHOLD);
        int graphSize = lgraph.getLayerlessNodes().size();
        if (!(interactiveCrossMin || greedySwitchType == GreedySwitchType.OFF || activationThreshold != 0 && activationThreshold <= graphSize)) {
            IntermediateProcessorStrategy internalGreedyType = greedySwitchType == GreedySwitchType.ONE_SIDED ? IntermediateProcessorStrategy.ONE_SIDED_GREEDY_SWITCH : IntermediateProcessorStrategy.TWO_SIDED_GREEDY_SWITCH;
            configuration.addBeforePhase4(internalGreedyType);
        }
        return configuration;
    }
}

