/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.model;

import com.google.gson.annotations.SerializedName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.lsat.external.api.model.LsatBase;
import org.eclipse.lsat.external.api.model.MotionSetting;
import org.eclipse.lsat.external.api.model.Path;
import org.eclipse.lsat.external.api.model.PeripheralType;
import org.eclipse.lsat.external.api.model.Resource;
import org.eclipse.lsat.external.api.model.TimingSetting;

public class Peripheral
extends LsatBase {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_PERIPHERAL_TYPE_ID = "peripheralTypeId";
    @SerializedName(value="peripheralTypeId")
    @Nonnull
    private String peripheralTypeId;
    private transient PeripheralType peripheralType;
    public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
    @SerializedName(value="resourceId")
    @Nonnull
    private String resourceId;
    private transient Resource resource;
    public static final String SERIALIZED_NAME_PROFILES = "profiles";
    @SerializedName(value="profiles")
    @Nullable
    private List<String> profiles = new ArrayList<String>();
    public static final String SERIALIZED_NAME_POSITIONS = "positions";
    @SerializedName(value="positions")
    @Nullable
    private Map<String, Map<String, Double>> positions = new LinkedHashMap<String, Map<String, Double>>();
    public static final String SERIALIZED_NAME_PATHS = "paths";
    @SerializedName(value="paths")
    @Nullable
    private List<Path> paths = new ArrayList<Path>();
    public static final String SERIALIZED_NAME_DISTANCES = "distances";
    @SerializedName(value="distances")
    @Nullable
    private List<String> distances = new ArrayList<String>();
    public static final String SERIALIZED_NAME_MOTION_SETTINGS = "motionSettings";
    @SerializedName(value="motionSettings")
    @Nullable
    private Map<String, MotionSetting> motionSettings = new LinkedHashMap<String, MotionSetting>();
    public static final String SERIALIZED_NAME_TIMING_SETTINGS = "timingSettings";
    @SerializedName(value="timingSettings")
    @Nullable
    private Map<String, TimingSetting> timingSettings = new LinkedHashMap<String, TimingSetting>();

    public Peripheral name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Peripheral peripheralTypeId(@Nonnull String peripheralTypeId) {
        this.peripheralTypeId = peripheralTypeId;
        return this;
    }

    @Nonnull
    public String getPeripheralTypeId() {
        return this.peripheralTypeId;
    }

    public void setPeripheralTypeId(@Nonnull String peripheralTypeId) {
        this.peripheralTypeId = peripheralTypeId;
    }

    public Peripheral resourceId(@Nonnull String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nonnull
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(@Nonnull String resourceId) {
        this.resourceId = resourceId;
    }

    public Peripheral profiles(@Nullable List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public Peripheral addProfilesItem(String profilesItem) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<String>();
        }
        this.profiles.add(profilesItem);
        return this;
    }

    @Nullable
    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(@Nullable List<String> profiles) {
        this.profiles = profiles;
    }

    public Peripheral positions(@Nullable Map<String, Map<String, Double>> positions) {
        this.positions = positions;
        return this;
    }

    public Peripheral putPositionsItem(String key, Map<String, Double> positionsItem) {
        if (this.positions == null) {
            this.positions = new LinkedHashMap<String, Map<String, Double>>();
        }
        this.positions.put(key, positionsItem);
        return this;
    }

    @Nullable
    public Map<String, Map<String, Double>> getPositions() {
        return this.positions;
    }

    public void setPositions(@Nullable Map<String, Map<String, Double>> positions) {
        this.positions = positions;
    }

    public Peripheral paths(@Nullable List<Path> paths) {
        this.paths = paths;
        return this;
    }

    public Peripheral addPathsItem(Path pathsItem) {
        if (this.paths == null) {
            this.paths = new ArrayList<Path>();
        }
        this.paths.add(pathsItem);
        return this;
    }

    @Nullable
    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(@Nullable List<Path> paths) {
        this.paths = paths;
    }

    public Peripheral distances(@Nullable List<String> distances) {
        this.distances = distances;
        return this;
    }

    public Peripheral addDistancesItem(String distancesItem) {
        if (this.distances == null) {
            this.distances = new ArrayList<String>();
        }
        this.distances.add(distancesItem);
        return this;
    }

    @Nullable
    public List<String> getDistances() {
        return this.distances;
    }

    public void setDistances(@Nullable List<String> distances) {
        this.distances = distances;
    }

    public Peripheral motionSettings(@Nullable Map<String, MotionSetting> motionSettings) {
        this.motionSettings = motionSettings;
        return this;
    }

    public Peripheral putMotionSettingsItem(String key, MotionSetting motionSettingsItem) {
        if (this.motionSettings == null) {
            this.motionSettings = new LinkedHashMap<String, MotionSetting>();
        }
        this.motionSettings.put(key, motionSettingsItem);
        return this;
    }

    @Nullable
    public Map<String, MotionSetting> getMotionSettings() {
        return this.motionSettings;
    }

    public void setMotionSettings(@Nullable Map<String, MotionSetting> motionSettings) {
        this.motionSettings = motionSettings;
    }

    public Peripheral timingSettings(@Nullable Map<String, TimingSetting> timingSettings) {
        this.timingSettings = timingSettings;
        return this;
    }

    public Peripheral putTimingSettingsItem(String key, TimingSetting timingSettingsItem) {
        if (this.timingSettings == null) {
            this.timingSettings = new LinkedHashMap<String, TimingSetting>();
        }
        this.timingSettings.put(key, timingSettingsItem);
        return this;
    }

    @Nullable
    public Map<String, TimingSetting> getTimingSettings() {
        return this.timingSettings;
    }

    public void setTimingSettings(@Nullable Map<String, TimingSetting> timingSettings) {
        this.timingSettings = timingSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peripheral peripheral = (Peripheral)o;
        return Objects.equals(this.name, peripheral.name) && Objects.equals(this.peripheralTypeId, peripheral.peripheralTypeId) && Objects.equals(this.resourceId, peripheral.resourceId) && Objects.equals(this.profiles, peripheral.profiles) && Objects.equals(this.positions, peripheral.positions) && Objects.equals(this.paths, peripheral.paths) && Objects.equals(this.distances, peripheral.distances) && Objects.equals(this.motionSettings, peripheral.motionSettings) && Objects.equals(this.timingSettings, peripheral.timingSettings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.peripheralTypeId, this.resourceId, this.profiles, this.positions, this.paths, this.distances, this.motionSettings, this.timingSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Peripheral {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    peripheralTypeId: ").append(this.toIndentedString(this.peripheralTypeId)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    profiles: ").append(this.toIndentedString(this.profiles)).append("\n");
        sb.append("    positions: ").append(this.toIndentedString(this.positions)).append("\n");
        sb.append("    paths: ").append(this.toIndentedString(this.paths)).append("\n");
        sb.append("    distances: ").append(this.toIndentedString(this.distances)).append("\n");
        sb.append("    motionSettings: ").append(this.toIndentedString(this.motionSettings)).append("\n");
        sb.append("    timingSettings: ").append(this.toIndentedString(this.timingSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public PeripheralType getPeripheralType() {
        return this.peripheralType;
    }

    public Resource getResource() {
        return this.resource;
    }
}

