# coding: utf-8

"""
    LSAT API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from lsat_client.models.lsat_base import LsatBase
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from lsat_client.models.task_attributes_value import TaskAttributesValue
from lsat_client.models.task_annotation_boolean import TaskAnnotationBoolean
from lsat_client.models.stochastic_annotation import StochasticAnnotation
from lsat_client.models.task_type import TaskType
from typing import Optional, Set
from typing_extensions import Self

class Task(LsatBase):
    """
    Task
    """ # noqa: E501
    name: StrictStr
    start_time: Union[StrictFloat, StrictInt] = Field(alias="startTime")
    duration: Union[StrictFloat, StrictInt]
    @property
    def end_time(self):
        return self.start_time + self.duration
    action: object = Field(default=None, repr=False)
    action_id: Optional[StrictStr] = Field(default=None, alias="actionId")
    activity: object = Field(default=None, repr=False)
    activity_id: Optional[StrictStr] = Field(default=None, alias="activityId")
    dispatch: object = Field(default=None, repr=False)
    dispatch_id: Optional[StrictStr] = Field(default=None, alias="dispatchId")
    attributes: Optional[Dict[str, TaskAttributesValue]] = None
    @property
    def critical(self) -> Optional[bool]:
        if self.attributes is None:
            return None
        critical = self.attributes.get('critical')
        if critical is None:
            return None
        if isinstance(critical.actual_instance, TaskAnnotationBoolean):
            return critical.actual_instance.value
        else:
            return None
    @property
    def stochastics(self) -> Optional[StochasticAnnotation]:
        if self.attributes is None:
            return None
        stochastics = self.attributes.get('stochastics')
        if stochastics is None:
            return None
        if isinstance(stochastics.actual_instance, StochasticAnnotation):
            return stochastics.actual_instance
        else:
            return None
    execution_data: Optional[Dict[str, Dict[str, List[Union[StrictFloat, StrictInt]]]]] = Field(default=None, alias="executionData")
    type: TaskType
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "startTime", "duration", "endTime", "actionId", "activityId", "dispatchId", "attributes", "executionData", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Task from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "end_time",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in attributes (dict)
        _field_dict = {}
        if self.attributes:
            for _key_attributes in self.attributes:
                if self.attributes[_key_attributes]:
                    _field_dict[_key_attributes] = self.attributes[_key_attributes].to_dict()
            _dict['attributes'] = _field_dict
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Task from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "startTime": obj.get("startTime"),
            "duration": obj.get("duration"),
            "endTime": obj.get("endTime"),
            "actionId": obj.get("actionId"),
            "activityId": obj.get("activityId"),
            "dispatchId": obj.get("dispatchId"),
            "attributes": dict(
                (_k, TaskAttributesValue.from_dict(_v))
                for _k, _v in obj["attributes"].items()
            )
            if obj.get("attributes") is not None
            else None,
            "executionData": obj.get("executionData"),
            "type": obj.get("type")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


