/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.PrintWriter;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.Benchmark;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator.Tor;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;

public class TorFullBenchmark
extends Benchmark {
    private final String name;
    private final Integer sizeMin;
    private final Integer sizeMax;
    private final Integer stepSize;
    private final Integer maxWeight1;
    private final Integer maxWeight2;
    private PrintWriter file;

    public TorFullBenchmark(String name, Integer sizeMin, Integer sizeMax, Integer stepSize, Integer maxWeight1, Integer maxWeight2) {
        this.name = name;
        this.sizeMin = sizeMin;
        this.sizeMax = sizeMax;
        this.stepSize = stepSize;
        this.maxWeight1 = maxWeight1;
        this.maxWeight2 = maxWeight2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run(Integer numberOfIterations, boolean runPI, boolean runEG, boolean runZP) {
        this.file = this.getFile(this.name);
        this.file.printf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n", "N", "maxWeight1", "maxWeight2", "PolicyIterationN", "EnergyGameN", "ZwickPatersonN", "PolicyIterationRE105", "EnergyGameRE105", "ZwickPatersonRE105", "PolicyIterationRInt", "EnergyGameRInt", "ZwickPatersonRInt");
        System.out.printf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n", "N", "maxWeight1", "maxWeight2", "PolicyIterationN", "EnergyGameN", "ZwickPatersonN", "PolicyIterationRE105", "EnergyGameRE105", "ZwickPatersonRE105", "PolicyIterationRInt", "EnergyGameRInt", "ZwickPatersonRInt");
        int runId = 0;
        while (runId < numberOfIterations) {
            int v = this.sizeMin;
            while (v <= this.sizeMax) {
                this.runAlgorithmsTor(v, this.maxWeight1, this.maxWeight2, runPI, runEG, runZP);
                v += this.stepSize.intValue();
            }
            ++runId;
        }
        this.file.close();
    }

    private void runAlgorithmsTor(Integer size, Integer maxWeight1, Integer maxWeight2, boolean runPI, boolean runEG, boolean runZP) {
        RGDoubleImplJGraphT torGraph = Tor.generateRatioGameDouble(size, maxWeight1, maxWeight2);
        float piSec = 0.0f;
        if (runPI) {
            long piResult = this.runPI(torGraph);
            piSec = (float)piResult / 1.0E9f;
        }
        float egSec = 0.0f;
        if (runEG) {
            long egResult = this.runEG(torGraph);
            egSec = (float)egResult / 1.0E9f;
        }
        float zpSec = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(torGraph);
            zpSec = (float)zpResult / 1.0E9f;
        }
        Double epsilon = 1.0E-4;
        float piSecD = 0.0f;
        if (runPI) {
            long piResult = this.runPI(torGraph, epsilon);
            piSecD = (float)piResult / 1.0E9f;
        }
        float egSecD = 0.0f;
        if (runEG) {
            long egResult = this.runEG(torGraph, epsilon);
            egSecD = (float)egResult / 1.0E9f;
        }
        float zpSecD = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(torGraph, epsilon);
            zpSecD = (float)zpResult / 1.0E9f;
        }
        long s = size.intValue();
        long cubic = s * s * s * s;
        epsilon = 1.0 / (1.0 * (double)cubic);
        epsilon = Double.max(1.0E-13, epsilon);
        float piSecD2 = 0.0f;
        if (runPI) {
            long piResult = this.runPI(torGraph, epsilon);
            piSecD2 = (float)piResult / 1.0E9f;
        }
        float egSecD2 = 0.0f;
        if (runEG) {
            long egResult = this.runEG(torGraph, epsilon);
            egSecD2 = (float)egResult / 1.0E9f;
        }
        float zpSecD2 = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(torGraph, epsilon);
            zpSecD2 = (float)zpResult / 1.0E9f;
        }
        this.file.printf("%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f\n", size, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec), Float.valueOf(piSecD), Float.valueOf(egSecD), Float.valueOf(zpSecD), Float.valueOf(piSecD2), Float.valueOf(egSecD2), Float.valueOf(zpSecD2));
        System.out.printf("%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f\n", size, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec), Float.valueOf(piSecD), Float.valueOf(egSecD), Float.valueOf(zpSecD), Float.valueOf(piSecD2), Float.valueOf(egSecD2), Float.valueOf(zpSecD2));
    }
}

