/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.hover;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.operations.hover.LSPTextHover;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HoverTest
extends AbstractTestWithProject {
    private LSPTextHover hover;

    @Before
    public void setUp() {
        this.hover = new LSPTextHover();
    }

    @Test
    public void testHoverRegion() throws CoreException {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.hover.getHoverRegion(viewer, 5));
    }

    @Test
    public void testHoverRegionInvalidOffset() throws CoreException {
        MockLanguageServer.INSTANCE.setHover(null);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals((Object)new Region(15, 0), (Object)this.hover.getHoverRegion(viewer, 15));
    }

    @Test
    public void testHoverInfo() throws CoreException {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertTrue((boolean)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)).contains("HoverContent"));
    }

    @Test
    public void testHoverInfoEmptyContentList() throws CoreException {
        Hover hoverResponse = new Hover(Collections.emptyList(), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals(null, (Object)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)));
    }

    @Test
    public void testHoverInfoInvalidOffset() throws CoreException {
        MockLanguageServer.INSTANCE.setHover(null);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals(null, (Object)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)));
    }

    @Test
    public void testHoverEmptyContentItem() throws CoreException {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals(null, (Object)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)));
    }

    @Test
    public void testHoverOnExternalFile() throws CoreException, IOException {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"blah")), new Range(new Position(0, 0), new Position(0, 0)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        File file = TestUtils.createTempFile("testHoverOnExternalfile", ".lspt");
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)IDE.openInternalEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI())));
        Assert.assertTrue((boolean)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 0)).contains("blah"));
    }

    @Test
    public void testMultipleHovers() throws Exception {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFileMultiLS(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        String hoverInfo = this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10));
        int index = hoverInfo.indexOf("HoverContent");
        Assert.assertNotEquals((String)"Hover content not found", (long)-1L, (long)index);
        index += "HoverContent".length();
        index = hoverInfo.indexOf("HoverContent", index);
        Assert.assertNotEquals((String)"Hover content found only once", (long)-1L, (long)index);
    }

    @Test
    public void testIntroUrlLink() throws Exception {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"[My intro URL link](http://org.eclipse.ui.intro/execute?command=org.eclipse.ui.file.close)")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        final IEditorPart editorPart = TestUtils.openEditor(file);
        TestUtils.waitForAndAssertCondition(5000, () -> LSPEclipseUtils.getTextViewer((IEditorPart)editorPart) != null);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editorPart);
        Assert.assertEquals((Object)UI.getActivePart(), (Object)editorPart);
        String hoverContent = this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10));
        LSPTextHover hoverManager = new LSPTextHover();
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell shell = new Shell(display);
        BrowserInformationControl wrapperControl = null;
        BrowserInformationControl control = null;
        try {
            RowLayout layout = new RowLayout(512);
            layout.fill = true;
            shell.setLayout((Layout)layout);
            shell.setSize(320, 200);
            shell.open();
            wrapperControl = (BrowserInformationControl)hoverManager.getHoverControlCreator().createInformationControl(shell);
            control = (BrowserInformationControl)wrapperControl.getInformationPresenterControlCreator().createInformationControl(shell);
            Field f = BrowserInformationControl.class.getDeclaredField("fBrowser");
            f.setAccessible(true);
            final Browser browser = (Browser)f.get(control);
            browser.setJavascriptEnabled(true);
            final AtomicBoolean completed = new AtomicBoolean(false);
            browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent event) {
                    browser.removeProgressListener((ProgressListener)this);
                    Assert.assertEquals((Object)UI.getActivePart(), (Object)editorPart);
                    browser.execute("document.getElementsByTagName('a')[0].click()");
                    completed.set(true);
                }
            });
            Assert.assertNotNull((String)"Editor should be opened", (Object)viewer.getTextWidget());
            UI.getActivePage().activate((IWorkbenchPart)editorPart);
            browser.setText(hoverContent);
            TestUtils.waitForAndAssertCondition("action didn't close editor", 10000, browser.getDisplay(), () -> completed.get() && (viewer.getTextWidget() == null || viewer.getTextWidget().isDisposed()));
        }
        finally {
            if (control != null) {
                control.dispose();
            }
            if (wrapperControl != null) {
                wrapperControl.dispose();
            }
            shell.dispose();
        }
    }
}

